package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

public class CSIDriverSpecFluentImpl<A extends CSIDriverSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CSIDriverSpecFluent<A> {

    private Boolean attachRequired;
    private String fsGroupPolicy;
    private Boolean podInfoOnMount;
    private Boolean requiresRepublish;
    private Boolean storageCapacity;
    private List<TokenRequestBuilder> tokenRequests =  new ArrayList<TokenRequestBuilder>();
    private List<String> volumeLifecycleModes = new ArrayList<String>();

    public CSIDriverSpecFluentImpl() {
    }

    public CSIDriverSpecFluentImpl(CSIDriverSpec instance) {
        this.withAttachRequired(instance.getAttachRequired()); 
        this.withFsGroupPolicy(instance.getFsGroupPolicy()); 
        this.withPodInfoOnMount(instance.getPodInfoOnMount()); 
        this.withRequiresRepublish(instance.getRequiresRepublish()); 
        this.withStorageCapacity(instance.getStorageCapacity()); 
        this.withTokenRequests(instance.getTokenRequests()); 
        this.withVolumeLifecycleModes(instance.getVolumeLifecycleModes()); 
    }

    public Boolean isAttachRequired() {
        return this.attachRequired;
    }

    public A withAttachRequired(Boolean attachRequired) {
        this.attachRequired=attachRequired; return (A) this;
    }

    public Boolean hasAttachRequired() {
        return this.attachRequired != null;
    }

    public A withNewAttachRequired(String arg1) {
        return (A)withAttachRequired(new Boolean(arg1));
    }

    public A withNewAttachRequired(boolean arg1) {
        return (A)withAttachRequired(new Boolean(arg1));
    }

    public String getFsGroupPolicy() {
        return this.fsGroupPolicy;
    }

    public A withFsGroupPolicy(String fsGroupPolicy) {
        this.fsGroupPolicy=fsGroupPolicy; return (A) this;
    }

    public Boolean hasFsGroupPolicy() {
        return this.fsGroupPolicy != null;
    }

    public A withNewFsGroupPolicy(String arg1) {
        return (A)withFsGroupPolicy(new String(arg1));
    }

    public A withNewFsGroupPolicy(StringBuilder arg1) {
        return (A)withFsGroupPolicy(new String(arg1));
    }

    public A withNewFsGroupPolicy(StringBuffer arg1) {
        return (A)withFsGroupPolicy(new String(arg1));
    }

    public Boolean isPodInfoOnMount() {
        return this.podInfoOnMount;
    }

    public A withPodInfoOnMount(Boolean podInfoOnMount) {
        this.podInfoOnMount=podInfoOnMount; return (A) this;
    }

    public Boolean hasPodInfoOnMount() {
        return this.podInfoOnMount != null;
    }

    public A withNewPodInfoOnMount(String arg1) {
        return (A)withPodInfoOnMount(new Boolean(arg1));
    }

    public A withNewPodInfoOnMount(boolean arg1) {
        return (A)withPodInfoOnMount(new Boolean(arg1));
    }

    public Boolean isRequiresRepublish() {
        return this.requiresRepublish;
    }

    public A withRequiresRepublish(Boolean requiresRepublish) {
        this.requiresRepublish=requiresRepublish; return (A) this;
    }

    public Boolean hasRequiresRepublish() {
        return this.requiresRepublish != null;
    }

    public A withNewRequiresRepublish(String arg1) {
        return (A)withRequiresRepublish(new Boolean(arg1));
    }

    public A withNewRequiresRepublish(boolean arg1) {
        return (A)withRequiresRepublish(new Boolean(arg1));
    }

    public Boolean isStorageCapacity() {
        return this.storageCapacity;
    }

    public A withStorageCapacity(Boolean storageCapacity) {
        this.storageCapacity=storageCapacity; return (A) this;
    }

    public Boolean hasStorageCapacity() {
        return this.storageCapacity != null;
    }

    public A withNewStorageCapacity(String arg1) {
        return (A)withStorageCapacity(new Boolean(arg1));
    }

    public A withNewStorageCapacity(boolean arg1) {
        return (A)withStorageCapacity(new Boolean(arg1));
    }

    public A addToTokenRequests(int index,TokenRequest item) {
        if (this.tokenRequests == null) {this.tokenRequests = new ArrayList<TokenRequestBuilder>();}
        TokenRequestBuilder builder = new TokenRequestBuilder(item);_visitables.get("tokenRequests").add(index >= 0 ? index : _visitables.get("tokenRequests").size(), builder);this.tokenRequests.add(index >= 0 ? index : tokenRequests.size(), builder); return (A)this;
    }

    public A setToTokenRequests(int index,TokenRequest item) {
        if (this.tokenRequests == null) {this.tokenRequests = new ArrayList<TokenRequestBuilder>();}
        TokenRequestBuilder builder = new TokenRequestBuilder(item);
        if (index < 0 || index >= _visitables.get("tokenRequests").size()) { _visitables.get("tokenRequests").add(builder); } else { _visitables.get("tokenRequests").set(index, builder);}
        if (index < 0 || index >= tokenRequests.size()) { tokenRequests.add(builder); } else { tokenRequests.set(index, builder);}
         return (A)this;
    }

    public A addToTokenRequests(TokenRequest... items) {
        if (this.tokenRequests == null) {this.tokenRequests = new ArrayList<TokenRequestBuilder>();}
        for (TokenRequest item : items) {TokenRequestBuilder builder = new TokenRequestBuilder(item);_visitables.get("tokenRequests").add(builder);this.tokenRequests.add(builder);} return (A)this;
    }

    public A addAllToTokenRequests(Collection<TokenRequest> items) {
        if (this.tokenRequests == null) {this.tokenRequests = new ArrayList<TokenRequestBuilder>();}
        for (TokenRequest item : items) {TokenRequestBuilder builder = new TokenRequestBuilder(item);_visitables.get("tokenRequests").add(builder);this.tokenRequests.add(builder);} return (A)this;
    }

    public A removeFromTokenRequests(TokenRequest... items) {
        for (TokenRequest item : items) {TokenRequestBuilder builder = new TokenRequestBuilder(item);_visitables.get("tokenRequests").remove(builder);if (this.tokenRequests != null) {this.tokenRequests.remove(builder);}} return (A)this;
    }

    public A removeAllFromTokenRequests(Collection<TokenRequest> items) {
        for (TokenRequest item : items) {TokenRequestBuilder builder = new TokenRequestBuilder(item);_visitables.get("tokenRequests").remove(builder);if (this.tokenRequests != null) {this.tokenRequests.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTokenRequests(Predicate<TokenRequestBuilder> predicate) {
        if (tokenRequests == null) return (A) this;
        final Iterator<TokenRequestBuilder> each = tokenRequests.iterator();
        final List visitables = _visitables.get("tokenRequests");
        while (each.hasNext()) {
          TokenRequestBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTokenRequests instead.
 * @return The buildable object.
 */
@Deprecated public List<TokenRequest> getTokenRequests() {
        return build(tokenRequests);
    }

    public List<TokenRequest> buildTokenRequests() {
        return build(tokenRequests);
    }

    public TokenRequest buildTokenRequest(int index) {
        return this.tokenRequests.get(index).build();
    }

    public TokenRequest buildFirstTokenRequest() {
        return this.tokenRequests.get(0).build();
    }

    public TokenRequest buildLastTokenRequest() {
        return this.tokenRequests.get(tokenRequests.size() - 1).build();
    }

    public TokenRequest buildMatchingTokenRequest(Predicate<TokenRequestBuilder> predicate) {
        for (TokenRequestBuilder item: tokenRequests) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingTokenRequest(Predicate<TokenRequestBuilder> predicate) {
        for (TokenRequestBuilder item: tokenRequests) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTokenRequests(List<TokenRequest> tokenRequests) {
        if (this.tokenRequests != null) { _visitables.get("tokenRequests").removeAll(this.tokenRequests);}
        if (tokenRequests != null) {this.tokenRequests = new ArrayList<TokenRequestBuilder>(); for (TokenRequest item : tokenRequests){this.addToTokenRequests(item);}} else { this.tokenRequests = null;} return (A) this;
    }

    public A withTokenRequests(TokenRequest... tokenRequests) {
        if (this.tokenRequests != null) {this.tokenRequests.clear();}
        if (tokenRequests != null) {for (TokenRequest item :tokenRequests){ this.addToTokenRequests(item);}} return (A) this;
    }

    public Boolean hasTokenRequests() {
        return tokenRequests != null && !tokenRequests.isEmpty();
    }

    public A addNewTokenRequest(String audience,Long expirationSeconds) {
        return (A)addToTokenRequests(new TokenRequest(audience, expirationSeconds));
    }

    public CSIDriverSpecFluent.TokenRequestsNested<A> addNewTokenRequest() {
        return new TokenRequestsNestedImpl();
    }

    public CSIDriverSpecFluent.TokenRequestsNested<A> addNewTokenRequestLike(TokenRequest item) {
        return new TokenRequestsNestedImpl(-1, item);
    }

    public CSIDriverSpecFluent.TokenRequestsNested<A> setNewTokenRequestLike(int index,TokenRequest item) {
        return new TokenRequestsNestedImpl(index, item);
    }

    public CSIDriverSpecFluent.TokenRequestsNested<A> editTokenRequest(int index) {
        if (tokenRequests.size() <= index) throw new RuntimeException("Can't edit tokenRequests. Index exceeds size.");
        return setNewTokenRequestLike(index, buildTokenRequest(index));
    }

    public CSIDriverSpecFluent.TokenRequestsNested<A> editFirstTokenRequest() {
        if (tokenRequests.size() == 0) throw new RuntimeException("Can't edit first tokenRequests. The list is empty.");
        return setNewTokenRequestLike(0, buildTokenRequest(0));
    }

    public CSIDriverSpecFluent.TokenRequestsNested<A> editLastTokenRequest() {
        int index = tokenRequests.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last tokenRequests. The list is empty.");
        return setNewTokenRequestLike(index, buildTokenRequest(index));
    }

    public CSIDriverSpecFluent.TokenRequestsNested<A> editMatchingTokenRequest(Predicate<TokenRequestBuilder> predicate) {
        int index = -1;
        for (int i=0;i<tokenRequests.size();i++) { 
        if (predicate.test(tokenRequests.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching tokenRequests. No match found.");
        return setNewTokenRequestLike(index, buildTokenRequest(index));
    }

    public A addToVolumeLifecycleModes(int index,String item) {
        if (this.volumeLifecycleModes == null) {this.volumeLifecycleModes = new ArrayList<String>();}
        this.volumeLifecycleModes.add(index, item);
        return (A)this;
    }

    public A setToVolumeLifecycleModes(int index,String item) {
        if (this.volumeLifecycleModes == null) {this.volumeLifecycleModes = new ArrayList<String>();}
        this.volumeLifecycleModes.set(index, item); return (A)this;
    }

    public A addToVolumeLifecycleModes(String... items) {
        if (this.volumeLifecycleModes == null) {this.volumeLifecycleModes = new ArrayList<String>();}
        for (String item : items) {this.volumeLifecycleModes.add(item);} return (A)this;
    }

    public A addAllToVolumeLifecycleModes(Collection<String> items) {
        if (this.volumeLifecycleModes == null) {this.volumeLifecycleModes = new ArrayList<String>();}
        for (String item : items) {this.volumeLifecycleModes.add(item);} return (A)this;
    }

    public A removeFromVolumeLifecycleModes(String... items) {
        for (String item : items) {if (this.volumeLifecycleModes!= null){ this.volumeLifecycleModes.remove(item);}} return (A)this;
    }

    public A removeAllFromVolumeLifecycleModes(Collection<String> items) {
        for (String item : items) {if (this.volumeLifecycleModes!= null){ this.volumeLifecycleModes.remove(item);}} return (A)this;
    }

    public List<String> getVolumeLifecycleModes() {
        return this.volumeLifecycleModes;
    }

    public String getVolumeLifecycleMode(int index) {
        return this.volumeLifecycleModes.get(index);
    }

    public String getFirstVolumeLifecycleMode() {
        return this.volumeLifecycleModes.get(0);
    }

    public String getLastVolumeLifecycleMode() {
        return this.volumeLifecycleModes.get(volumeLifecycleModes.size() - 1);
    }

    public String getMatchingVolumeLifecycleMode(Predicate<String> predicate) {
        for (String item: volumeLifecycleModes) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingVolumeLifecycleMode(Predicate<String> predicate) {
        for (String item: volumeLifecycleModes) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withVolumeLifecycleModes(List<String> volumeLifecycleModes) {
        if (this.volumeLifecycleModes != null) { _visitables.get("volumeLifecycleModes").removeAll(this.volumeLifecycleModes);}
        if (volumeLifecycleModes != null) {this.volumeLifecycleModes = new ArrayList<String>(); for (String item : volumeLifecycleModes){this.addToVolumeLifecycleModes(item);}} else { this.volumeLifecycleModes = null;} return (A) this;
    }

    public A withVolumeLifecycleModes(String... volumeLifecycleModes) {
        if (this.volumeLifecycleModes != null) {this.volumeLifecycleModes.clear();}
        if (volumeLifecycleModes != null) {for (String item :volumeLifecycleModes){ this.addToVolumeLifecycleModes(item);}} return (A) this;
    }

    public Boolean hasVolumeLifecycleModes() {
        return volumeLifecycleModes != null && !volumeLifecycleModes.isEmpty();
    }

    public A addNewVolumeLifecycleMode(String arg1) {
        return (A)addToVolumeLifecycleModes(new String(arg1));
    }

    public A addNewVolumeLifecycleMode(StringBuilder arg1) {
        return (A)addToVolumeLifecycleModes(new String(arg1));
    }

    public A addNewVolumeLifecycleMode(StringBuffer arg1) {
        return (A)addToVolumeLifecycleModes(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CSIDriverSpecFluentImpl that = (CSIDriverSpecFluentImpl) o;
        if (attachRequired != null ? !attachRequired.equals(that.attachRequired) :that.attachRequired != null) return false;
        if (fsGroupPolicy != null ? !fsGroupPolicy.equals(that.fsGroupPolicy) :that.fsGroupPolicy != null) return false;
        if (podInfoOnMount != null ? !podInfoOnMount.equals(that.podInfoOnMount) :that.podInfoOnMount != null) return false;
        if (requiresRepublish != null ? !requiresRepublish.equals(that.requiresRepublish) :that.requiresRepublish != null) return false;
        if (storageCapacity != null ? !storageCapacity.equals(that.storageCapacity) :that.storageCapacity != null) return false;
        if (tokenRequests != null ? !tokenRequests.equals(that.tokenRequests) :that.tokenRequests != null) return false;
        if (volumeLifecycleModes != null ? !volumeLifecycleModes.equals(that.volumeLifecycleModes) :that.volumeLifecycleModes != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(attachRequired,  fsGroupPolicy,  podInfoOnMount,  requiresRepublish,  storageCapacity,  tokenRequests,  volumeLifecycleModes,  super.hashCode());
    }

    public class TokenRequestsNestedImpl<N> extends TokenRequestFluentImpl<CSIDriverSpecFluent.TokenRequestsNested<N>> implements CSIDriverSpecFluent.TokenRequestsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TokenRequestBuilder builder;
        private final int index;

            TokenRequestsNestedImpl(int index,TokenRequest item) {
                this.index = index;
                this.builder = new TokenRequestBuilder(this, item);
                        
            }

            TokenRequestsNestedImpl() {
                this.index = -1;
                this.builder = new TokenRequestBuilder(this);
                        
            }

            public N and() {
                return (N) CSIDriverSpecFluentImpl.this.setToTokenRequests(index,builder.build());
            }

            public N endTokenRequest() {
                return and();
            }
    }


}
