package io.fabric8.kubernetes.api.model.storage;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class VolumeErrorFluentImpl<A extends VolumeErrorFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements VolumeErrorFluent<A> {

    private String message;
    private String time;

    public VolumeErrorFluentImpl() {
    }

    public VolumeErrorFluentImpl(VolumeError instance) {
        this.withMessage(instance.getMessage()); 
        this.withTime(instance.getTime()); 
    }

    public String getMessage() {
        return this.message;
    }

    public A withMessage(String message) {
        this.message=message; return (A) this;
    }

    public Boolean hasMessage() {
        return this.message != null;
    }

    public A withNewMessage(String arg1) {
        return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuilder arg1) {
        return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuffer arg1) {
        return (A)withMessage(new String(arg1));
    }

    public String getTime() {
        return this.time;
    }

    public A withTime(String time) {
        this.time=time; return (A) this;
    }

    public Boolean hasTime() {
        return this.time != null;
    }

    public A withNewTime(String arg1) {
        return (A)withTime(new String(arg1));
    }

    public A withNewTime(StringBuilder arg1) {
        return (A)withTime(new String(arg1));
    }

    public A withNewTime(StringBuffer arg1) {
        return (A)withTime(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        VolumeErrorFluentImpl that = (VolumeErrorFluentImpl) o;
        if (message != null ? !message.equals(that.message) :that.message != null) return false;
        if (time != null ? !time.equals(that.time) :that.time != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(message,  time,  super.hashCode());
    }

}
