package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CSIDriverListBuilder extends CSIDriverListFluentImpl<CSIDriverListBuilder> implements VisitableBuilder<CSIDriverList,CSIDriverListBuilder> {

    CSIDriverListFluent<?> fluent;
    Boolean validationEnabled;

    public CSIDriverListBuilder() {
        this(true);
    }

    public CSIDriverListBuilder(Boolean validationEnabled) {
        this(new CSIDriverList(), validationEnabled);
    }

    public CSIDriverListBuilder(CSIDriverListFluent<?> fluent) {
        this(fluent, true);
    }

    public CSIDriverListBuilder(CSIDriverListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CSIDriverList(), validationEnabled);
    }

    public CSIDriverListBuilder(CSIDriverListFluent<?> fluent,CSIDriverList instance) {
        this(fluent, instance, true);
    }

    public CSIDriverListBuilder(CSIDriverListFluent<?> fluent,CSIDriverList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public CSIDriverListBuilder(CSIDriverList instance) {
        this(instance,true);
    }

    public CSIDriverListBuilder(CSIDriverList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public CSIDriverList build() {
        CSIDriverList buildable = new CSIDriverList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CSIDriverListBuilder that = (CSIDriverListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
