package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class VolumeNodeResourcesBuilder extends VolumeNodeResourcesFluentImpl<VolumeNodeResourcesBuilder> implements VisitableBuilder<VolumeNodeResources,VolumeNodeResourcesBuilder> {

    VolumeNodeResourcesFluent<?> fluent;
    Boolean validationEnabled;

    public VolumeNodeResourcesBuilder() {
        this(true);
    }

    public VolumeNodeResourcesBuilder(Boolean validationEnabled) {
        this(new VolumeNodeResources(), validationEnabled);
    }

    public VolumeNodeResourcesBuilder(VolumeNodeResourcesFluent<?> fluent) {
        this(fluent, true);
    }

    public VolumeNodeResourcesBuilder(VolumeNodeResourcesFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new VolumeNodeResources(), validationEnabled);
    }

    public VolumeNodeResourcesBuilder(VolumeNodeResourcesFluent<?> fluent,VolumeNodeResources instance) {
        this(fluent, instance, true);
    }

    public VolumeNodeResourcesBuilder(VolumeNodeResourcesFluent<?> fluent,VolumeNodeResources instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCount(instance.getCount()); 
        this.validationEnabled = validationEnabled; 
    }

    public VolumeNodeResourcesBuilder(VolumeNodeResources instance) {
        this(instance,true);
    }

    public VolumeNodeResourcesBuilder(VolumeNodeResources instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withCount(instance.getCount()); 
        this.validationEnabled = validationEnabled; 
    }

    public VolumeNodeResources build() {
        VolumeNodeResources buildable = new VolumeNodeResources(fluent.getCount());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        VolumeNodeResourcesBuilder that = (VolumeNodeResourcesBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
