package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class VolumeErrorBuilder extends VolumeErrorFluentImpl<VolumeErrorBuilder> implements VisitableBuilder<VolumeError,VolumeErrorBuilder> {

    VolumeErrorFluent<?> fluent;
    Boolean validationEnabled;

    public VolumeErrorBuilder() { 
        this(true);
    }


    public VolumeErrorBuilder(Boolean validationEnabled) { 
        this(new VolumeError(), validationEnabled);
    }


    public VolumeErrorBuilder(VolumeErrorFluent<?> fluent) { 
        this(fluent, true);
    }


    public VolumeErrorBuilder(VolumeErrorFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new VolumeError(), validationEnabled);
    }


    public VolumeErrorBuilder(VolumeErrorFluent<?> fluent,VolumeError instance) { 
        this(fluent, instance, true);
    }


    public VolumeErrorBuilder(VolumeErrorFluent<?> fluent,VolumeError instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withMessage(instance.getMessage()); 
        fluent.withTime(instance.getTime()); 
        this.validationEnabled = validationEnabled; 
    }


    public VolumeErrorBuilder(VolumeError instance) { 
        this(instance,true);
    }


    public VolumeErrorBuilder(VolumeError instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withMessage(instance.getMessage()); 
        this.withTime(instance.getTime()); 
        this.validationEnabled = validationEnabled; 
    }


    public VolumeError build() {
        VolumeError buildable = new VolumeError(fluent.getMessage(),fluent.getTime());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        VolumeErrorBuilder that = (VolumeErrorBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
