package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface CSINodeFluent<A extends CSINodeFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public CSINodeFluent.MetadataNested<A> withNewMetadata();
    public CSINodeFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public CSINodeFluent.MetadataNested<A> editMetadata();
    public CSINodeFluent.MetadataNested<A> editOrNewMetadata();
    public CSINodeFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public CSINodeSpec getSpec();
    public CSINodeSpec buildSpec();
    public A withSpec(CSINodeSpec spec);
    public Boolean hasSpec();
    public CSINodeFluent.SpecNested<A> withNewSpec();
    public CSINodeFluent.SpecNested<A> withNewSpecLike(CSINodeSpec item);
    public CSINodeFluent.SpecNested<A> editSpec();
    public CSINodeFluent.SpecNested<A> editOrNewSpec();
    public CSINodeFluent.SpecNested<A> editOrNewSpecLike(CSINodeSpec item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<CSINodeFluent.MetadataNested<N>> {

        public N and();
        public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CSINodeSpecFluent<CSINodeFluent.SpecNested<N>> {

        public N and();
        public N endSpec();    }


}
