
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.storage.StorageClass;
import io.fabric8.kubernetes.api.model.storage.StorageClassList;
import io.fabric8.kubernetes.api.model.storage.VolumeAttachment;
import io.fabric8.kubernetes.api.model.storage.VolumeAttachmentList;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriver;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriverList;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSINode;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeList;
import io.fabric8.kubernetes.api.model.version.Info;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "APIGroup",
    "APIGroupList",
    "BaseKubernetesList",
    "CSIDriver",
    "CSIDriverList",
    "CSINode",
    "CSINodeList",
    "CreateOptions",
    "DeleteOptions",
    "GetOptions",
    "Info",
    "ListOptions",
    "ObjectMeta",
    "ObjectReference",
    "Patch",
    "PatchOptions",
    "Quantity",
    "RootPaths",
    "Status",
    "StorageClass",
    "StorageClassList",
    "Time",
    "TypeMeta",
    "UpdateOptions",
    "VolumeAttachment",
    "VolumeAttachmentList"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(io.fabric8.kubernetes.api.model.ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(io.fabric8.kubernetes.api.model.ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class KubeSchema {

    /**
     * 
     */
    @JsonProperty("APIGroup")
    @JsonPropertyDescription("")
    private APIGroup aPIGroup;
    /**
     * 
     */
    @JsonProperty("APIGroupList")
    @JsonPropertyDescription("")
    private APIGroupList aPIGroupList;
    /**
     * 
     */
    @JsonProperty("BaseKubernetesList")
    @JsonPropertyDescription("")
    private BaseKubernetesList baseKubernetesList;
    /**
     * 
     */
    @JsonProperty("CSIDriver")
    @JsonPropertyDescription("")
    private CSIDriver cSIDriver;
    /**
     * 
     */
    @JsonProperty("CSIDriverList")
    @JsonPropertyDescription("")
    private CSIDriverList cSIDriverList;
    /**
     * 
     */
    @JsonProperty("CSINode")
    @JsonPropertyDescription("")
    private CSINode cSINode;
    /**
     * 
     */
    @JsonProperty("CSINodeList")
    @JsonPropertyDescription("")
    private CSINodeList cSINodeList;
    /**
     * 
     */
    @JsonProperty("CreateOptions")
    @JsonPropertyDescription("")
    private CreateOptions createOptions;
    /**
     * 
     */
    @JsonProperty("DeleteOptions")
    @JsonPropertyDescription("")
    private DeleteOptions deleteOptions;
    /**
     * 
     */
    @JsonProperty("GetOptions")
    @JsonPropertyDescription("")
    private GetOptions getOptions;
    /**
     * 
     */
    @JsonProperty("Info")
    @JsonPropertyDescription("")
    private Info info;
    /**
     * 
     */
    @JsonProperty("ListOptions")
    @JsonPropertyDescription("")
    private ListOptions listOptions;
    /**
     * 
     */
    @JsonProperty("ObjectMeta")
    @JsonPropertyDescription("")
    private io.fabric8.kubernetes.api.model.ObjectMeta objectMeta;
    /**
     * 
     */
    @JsonProperty("ObjectReference")
    @JsonPropertyDescription("")
    private io.fabric8.kubernetes.api.model.ObjectReference objectReference;
    /**
     * 
     */
    @JsonProperty("Patch")
    @JsonPropertyDescription("")
    private Patch patch;
    /**
     * 
     */
    @JsonProperty("PatchOptions")
    @JsonPropertyDescription("")
    private PatchOptions patchOptions;
    /**
     * 
     */
    @JsonProperty("Quantity")
    @JsonPropertyDescription("")
    private Quantity quantity;
    /**
     * 
     */
    @JsonProperty("RootPaths")
    @JsonPropertyDescription("")
    private RootPaths rootPaths;
    /**
     * 
     */
    @JsonProperty("Status")
    @JsonPropertyDescription("")
    private Status status;
    /**
     * 
     */
    @JsonProperty("StorageClass")
    @JsonPropertyDescription("")
    private StorageClass storageClass;
    /**
     * 
     */
    @JsonProperty("StorageClassList")
    @JsonPropertyDescription("")
    private StorageClassList storageClassList;
    /**
     * 
     */
    @JsonProperty("Time")
    @JsonPropertyDescription("")
    private String time;
    /**
     * 
     */
    @JsonProperty("TypeMeta")
    @JsonPropertyDescription("")
    private TypeMeta typeMeta;
    /**
     * 
     */
    @JsonProperty("UpdateOptions")
    @JsonPropertyDescription("")
    private UpdateOptions updateOptions;
    /**
     * 
     */
    @JsonProperty("VolumeAttachment")
    @JsonPropertyDescription("")
    private VolumeAttachment volumeAttachment;
    /**
     * 
     */
    @JsonProperty("VolumeAttachmentList")
    @JsonPropertyDescription("")
    private VolumeAttachmentList volumeAttachmentList;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public KubeSchema() {
    }

    /**
     * 
     * @param listOptions
     * @param aPIGroupList
     * @param baseKubernetesList
     * @param updateOptions
     * @param cSIDriverList
     * @param cSINode
     * @param patch
     * @param cSINodeList
     * @param storageClass
     * @param volumeAttachmentList
     * @param rootPaths
     * @param info
     * @param cSIDriver
     * @param patchOptions
     * @param deleteOptions
     * @param quantity
     * @param volumeAttachment
     * @param storageClassList
     * @param objectReference
     * @param createOptions
     * @param aPIGroup
     * @param typeMeta
     * @param objectMeta
     * @param getOptions
     * @param time
     * @param status
     */
    public KubeSchema(APIGroup aPIGroup, APIGroupList aPIGroupList, BaseKubernetesList baseKubernetesList, CSIDriver cSIDriver, CSIDriverList cSIDriverList, CSINode cSINode, CSINodeList cSINodeList, CreateOptions createOptions, DeleteOptions deleteOptions, GetOptions getOptions, Info info, ListOptions listOptions, io.fabric8.kubernetes.api.model.ObjectMeta objectMeta, io.fabric8.kubernetes.api.model.ObjectReference objectReference, Patch patch, PatchOptions patchOptions, Quantity quantity, RootPaths rootPaths, Status status, StorageClass storageClass, StorageClassList storageClassList, String time, TypeMeta typeMeta, UpdateOptions updateOptions, VolumeAttachment volumeAttachment, VolumeAttachmentList volumeAttachmentList) {
        super();
        this.aPIGroup = aPIGroup;
        this.aPIGroupList = aPIGroupList;
        this.baseKubernetesList = baseKubernetesList;
        this.cSIDriver = cSIDriver;
        this.cSIDriverList = cSIDriverList;
        this.cSINode = cSINode;
        this.cSINodeList = cSINodeList;
        this.createOptions = createOptions;
        this.deleteOptions = deleteOptions;
        this.getOptions = getOptions;
        this.info = info;
        this.listOptions = listOptions;
        this.objectMeta = objectMeta;
        this.objectReference = objectReference;
        this.patch = patch;
        this.patchOptions = patchOptions;
        this.quantity = quantity;
        this.rootPaths = rootPaths;
        this.status = status;
        this.storageClass = storageClass;
        this.storageClassList = storageClassList;
        this.time = time;
        this.typeMeta = typeMeta;
        this.updateOptions = updateOptions;
        this.volumeAttachment = volumeAttachment;
        this.volumeAttachmentList = volumeAttachmentList;
    }

    /**
     * 
     */
    @JsonProperty("APIGroup")
    public APIGroup getAPIGroup() {
        return aPIGroup;
    }

    /**
     * 
     */
    @JsonProperty("APIGroup")
    public void setAPIGroup(APIGroup aPIGroup) {
        this.aPIGroup = aPIGroup;
    }

    /**
     * 
     */
    @JsonProperty("APIGroupList")
    public APIGroupList getAPIGroupList() {
        return aPIGroupList;
    }

    /**
     * 
     */
    @JsonProperty("APIGroupList")
    public void setAPIGroupList(APIGroupList aPIGroupList) {
        this.aPIGroupList = aPIGroupList;
    }

    /**
     * 
     */
    @JsonProperty("BaseKubernetesList")
    public BaseKubernetesList getBaseKubernetesList() {
        return baseKubernetesList;
    }

    /**
     * 
     */
    @JsonProperty("BaseKubernetesList")
    public void setBaseKubernetesList(BaseKubernetesList baseKubernetesList) {
        this.baseKubernetesList = baseKubernetesList;
    }

    /**
     * 
     */
    @JsonProperty("CSIDriver")
    public CSIDriver getCSIDriver() {
        return cSIDriver;
    }

    /**
     * 
     */
    @JsonProperty("CSIDriver")
    public void setCSIDriver(CSIDriver cSIDriver) {
        this.cSIDriver = cSIDriver;
    }

    /**
     * 
     */
    @JsonProperty("CSIDriverList")
    public CSIDriverList getCSIDriverList() {
        return cSIDriverList;
    }

    /**
     * 
     */
    @JsonProperty("CSIDriverList")
    public void setCSIDriverList(CSIDriverList cSIDriverList) {
        this.cSIDriverList = cSIDriverList;
    }

    /**
     * 
     */
    @JsonProperty("CSINode")
    public CSINode getCSINode() {
        return cSINode;
    }

    /**
     * 
     */
    @JsonProperty("CSINode")
    public void setCSINode(CSINode cSINode) {
        this.cSINode = cSINode;
    }

    /**
     * 
     */
    @JsonProperty("CSINodeList")
    public CSINodeList getCSINodeList() {
        return cSINodeList;
    }

    /**
     * 
     */
    @JsonProperty("CSINodeList")
    public void setCSINodeList(CSINodeList cSINodeList) {
        this.cSINodeList = cSINodeList;
    }

    /**
     * 
     */
    @JsonProperty("CreateOptions")
    public CreateOptions getCreateOptions() {
        return createOptions;
    }

    /**
     * 
     */
    @JsonProperty("CreateOptions")
    public void setCreateOptions(CreateOptions createOptions) {
        this.createOptions = createOptions;
    }

    /**
     * 
     */
    @JsonProperty("DeleteOptions")
    public DeleteOptions getDeleteOptions() {
        return deleteOptions;
    }

    /**
     * 
     */
    @JsonProperty("DeleteOptions")
    public void setDeleteOptions(DeleteOptions deleteOptions) {
        this.deleteOptions = deleteOptions;
    }

    /**
     * 
     */
    @JsonProperty("GetOptions")
    public GetOptions getGetOptions() {
        return getOptions;
    }

    /**
     * 
     */
    @JsonProperty("GetOptions")
    public void setGetOptions(GetOptions getOptions) {
        this.getOptions = getOptions;
    }

    /**
     * 
     */
    @JsonProperty("Info")
    public Info getInfo() {
        return info;
    }

    /**
     * 
     */
    @JsonProperty("Info")
    public void setInfo(Info info) {
        this.info = info;
    }

    /**
     * 
     */
    @JsonProperty("ListOptions")
    public ListOptions getListOptions() {
        return listOptions;
    }

    /**
     * 
     */
    @JsonProperty("ListOptions")
    public void setListOptions(ListOptions listOptions) {
        this.listOptions = listOptions;
    }

    /**
     * 
     */
    @JsonProperty("ObjectMeta")
    public io.fabric8.kubernetes.api.model.ObjectMeta getObjectMeta() {
        return objectMeta;
    }

    /**
     * 
     */
    @JsonProperty("ObjectMeta")
    public void setObjectMeta(io.fabric8.kubernetes.api.model.ObjectMeta objectMeta) {
        this.objectMeta = objectMeta;
    }

    /**
     * 
     */
    @JsonProperty("ObjectReference")
    public io.fabric8.kubernetes.api.model.ObjectReference getObjectReference() {
        return objectReference;
    }

    /**
     * 
     */
    @JsonProperty("ObjectReference")
    public void setObjectReference(io.fabric8.kubernetes.api.model.ObjectReference objectReference) {
        this.objectReference = objectReference;
    }

    /**
     * 
     */
    @JsonProperty("Patch")
    public Patch getPatch() {
        return patch;
    }

    /**
     * 
     */
    @JsonProperty("Patch")
    public void setPatch(Patch patch) {
        this.patch = patch;
    }

    /**
     * 
     */
    @JsonProperty("PatchOptions")
    public PatchOptions getPatchOptions() {
        return patchOptions;
    }

    /**
     * 
     */
    @JsonProperty("PatchOptions")
    public void setPatchOptions(PatchOptions patchOptions) {
        this.patchOptions = patchOptions;
    }

    /**
     * 
     */
    @JsonProperty("Quantity")
    public Quantity getQuantity() {
        return quantity;
    }

    /**
     * 
     */
    @JsonProperty("Quantity")
    public void setQuantity(Quantity quantity) {
        this.quantity = quantity;
    }

    /**
     * 
     */
    @JsonProperty("RootPaths")
    public RootPaths getRootPaths() {
        return rootPaths;
    }

    /**
     * 
     */
    @JsonProperty("RootPaths")
    public void setRootPaths(RootPaths rootPaths) {
        this.rootPaths = rootPaths;
    }

    /**
     * 
     */
    @JsonProperty("Status")
    public Status getStatus() {
        return status;
    }

    /**
     * 
     */
    @JsonProperty("Status")
    public void setStatus(Status status) {
        this.status = status;
    }

    /**
     * 
     */
    @JsonProperty("StorageClass")
    public StorageClass getStorageClass() {
        return storageClass;
    }

    /**
     * 
     */
    @JsonProperty("StorageClass")
    public void setStorageClass(StorageClass storageClass) {
        this.storageClass = storageClass;
    }

    /**
     * 
     */
    @JsonProperty("StorageClassList")
    public StorageClassList getStorageClassList() {
        return storageClassList;
    }

    /**
     * 
     */
    @JsonProperty("StorageClassList")
    public void setStorageClassList(StorageClassList storageClassList) {
        this.storageClassList = storageClassList;
    }

    /**
     * 
     */
    @JsonProperty("Time")
    public String getTime() {
        return time;
    }

    /**
     * 
     */
    @JsonProperty("Time")
    public void setTime(String time) {
        this.time = time;
    }

    /**
     * 
     */
    @JsonProperty("TypeMeta")
    public TypeMeta getTypeMeta() {
        return typeMeta;
    }

    /**
     * 
     */
    @JsonProperty("TypeMeta")
    public void setTypeMeta(TypeMeta typeMeta) {
        this.typeMeta = typeMeta;
    }

    /**
     * 
     */
    @JsonProperty("UpdateOptions")
    public UpdateOptions getUpdateOptions() {
        return updateOptions;
    }

    /**
     * 
     */
    @JsonProperty("UpdateOptions")
    public void setUpdateOptions(UpdateOptions updateOptions) {
        this.updateOptions = updateOptions;
    }

    /**
     * 
     */
    @JsonProperty("VolumeAttachment")
    public VolumeAttachment getVolumeAttachment() {
        return volumeAttachment;
    }

    /**
     * 
     */
    @JsonProperty("VolumeAttachment")
    public void setVolumeAttachment(VolumeAttachment volumeAttachment) {
        this.volumeAttachment = volumeAttachment;
    }

    /**
     * 
     */
    @JsonProperty("VolumeAttachmentList")
    public VolumeAttachmentList getVolumeAttachmentList() {
        return volumeAttachmentList;
    }

    /**
     * 
     */
    @JsonProperty("VolumeAttachmentList")
    public void setVolumeAttachmentList(VolumeAttachmentList volumeAttachmentList) {
        this.volumeAttachmentList = volumeAttachmentList;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
