package io.fabric8.kubernetes.api.model.storage.v1beta1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface CSIDriverSpecFluent<A extends CSIDriverSpecFluent<A>> extends Fluent<A> {


    public Boolean isAttachRequired();
    public A withAttachRequired(Boolean attachRequired);
    public Boolean hasAttachRequired();
    public A withNewAttachRequired(String arg1);
    public A withNewAttachRequired(boolean arg1);
    public String getFsGroupPolicy();
    public A withFsGroupPolicy(String fsGroupPolicy);
    public Boolean hasFsGroupPolicy();
    public A withNewFsGroupPolicy(String arg1);
    public A withNewFsGroupPolicy(StringBuilder arg1);
    public A withNewFsGroupPolicy(StringBuffer arg1);
    public Boolean isPodInfoOnMount();
    public A withPodInfoOnMount(Boolean podInfoOnMount);
    public Boolean hasPodInfoOnMount();
    public A withNewPodInfoOnMount(String arg1);
    public A withNewPodInfoOnMount(boolean arg1);
    public Boolean isStorageCapacity();
    public A withStorageCapacity(Boolean storageCapacity);
    public Boolean hasStorageCapacity();
    public A withNewStorageCapacity(String arg1);
    public A withNewStorageCapacity(boolean arg1);
    public A addToVolumeLifecycleModes(int index,String item);
    public A setToVolumeLifecycleModes(int index,String item);
    public A addToVolumeLifecycleModes(String... items);
    public A addAllToVolumeLifecycleModes(Collection<String> items);
    public A removeFromVolumeLifecycleModes(String... items);
    public A removeAllFromVolumeLifecycleModes(Collection<String> items);
    public List<String> getVolumeLifecycleModes();
    public String getVolumeLifecycleMode(int index);
    public String getFirstVolumeLifecycleMode();
    public String getLastVolumeLifecycleMode();
    public String getMatchingVolumeLifecycleMode(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingVolumeLifecycleMode(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withVolumeLifecycleModes(List<String> volumeLifecycleModes);
    public A withVolumeLifecycleModes(String... volumeLifecycleModes);
    public Boolean hasVolumeLifecycleModes();
    public A addNewVolumeLifecycleMode(String arg1);
    public A addNewVolumeLifecycleMode(StringBuilder arg1);
    public A addNewVolumeLifecycleMode(StringBuffer arg1);
}
