package io.fabric8.kubernetes.api.model.storage;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class VolumeAttachmentSpecFluentImpl<A extends VolumeAttachmentSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements VolumeAttachmentSpecFluent<A> {

    private String attacher;
    private String nodeName;
    private VolumeAttachmentSourceBuilder source;

    public VolumeAttachmentSpecFluentImpl() { 
    }


    public VolumeAttachmentSpecFluentImpl(VolumeAttachmentSpec instance) { 
        this.withAttacher(instance.getAttacher()); 
        this.withNodeName(instance.getNodeName()); 
        this.withSource(instance.getSource()); 
    }


    public String getAttacher() {
        return this.attacher;
    }

    public A withAttacher(String attacher) {
        this.attacher=attacher; return (A) this;
    }

    public Boolean hasAttacher() {
        return this.attacher != null;
    }

    public A withNewAttacher(String arg1) {
        return (A)withAttacher(new String(arg1));
    }

    public A withNewAttacher(StringBuilder arg1) {
        return (A)withAttacher(new String(arg1));
    }

    public A withNewAttacher(StringBuffer arg1) {
        return (A)withAttacher(new String(arg1));
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public A withNodeName(String nodeName) {
        this.nodeName=nodeName; return (A) this;
    }

    public Boolean hasNodeName() {
        return this.nodeName != null;
    }

    public A withNewNodeName(String arg1) {
        return (A)withNodeName(new String(arg1));
    }

    public A withNewNodeName(StringBuilder arg1) {
        return (A)withNodeName(new String(arg1));
    }

    public A withNewNodeName(StringBuffer arg1) {
        return (A)withNodeName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSource instead.
 * @return The buildable object.
 */
@Deprecated public VolumeAttachmentSource getSource() {
        return this.source!=null?this.source.build():null;
    }

    public VolumeAttachmentSource buildSource() {
        return this.source!=null?this.source.build():null;
    }

    public A withSource(VolumeAttachmentSource source) {
        _visitables.get("source").remove(this.source);
        if (source!=null){ this.source= new VolumeAttachmentSourceBuilder(source); _visitables.get("source").add(this.source);} return (A) this;
    }

    public Boolean hasSource() {
        return this.source != null;
    }

    public VolumeAttachmentSpecFluent.SourceNested<A> withNewSource() {
        return new SourceNestedImpl();
    }

    public VolumeAttachmentSpecFluent.SourceNested<A> withNewSourceLike(VolumeAttachmentSource item) {
        return new SourceNestedImpl(item);
    }

    public VolumeAttachmentSpecFluent.SourceNested<A> editSource() {
        return withNewSourceLike(getSource());
    }

    public VolumeAttachmentSpecFluent.SourceNested<A> editOrNewSource() {
        return withNewSourceLike(getSource() != null ? getSource(): new VolumeAttachmentSourceBuilder().build());
    }

    public VolumeAttachmentSpecFluent.SourceNested<A> editOrNewSourceLike(VolumeAttachmentSource item) {
        return withNewSourceLike(getSource() != null ? getSource(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        VolumeAttachmentSpecFluentImpl that = (VolumeAttachmentSpecFluentImpl) o;
        if (attacher != null ? !attacher.equals(that.attacher) :that.attacher != null) return false;
        if (nodeName != null ? !nodeName.equals(that.nodeName) :that.nodeName != null) return false;
        if (source != null ? !source.equals(that.source) :that.source != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(attacher,  nodeName,  source,  super.hashCode());
    }

    public class SourceNestedImpl<N> extends VolumeAttachmentSourceFluentImpl<VolumeAttachmentSpecFluent.SourceNested<N>> implements VolumeAttachmentSpecFluent.SourceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final VolumeAttachmentSourceBuilder builder;

        SourceNestedImpl(VolumeAttachmentSource item) {
            this.builder = new VolumeAttachmentSourceBuilder(this, item);
        }

        SourceNestedImpl() {
            this.builder = new VolumeAttachmentSourceBuilder(this);
        }

        public N and() {
             return (N) VolumeAttachmentSpecFluentImpl.this.withSource(builder.build());
        }

        public N endSource() {
             return and();
        }
    }


}
