package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class CSINodeSpecFluentImpl<A extends CSINodeSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CSINodeSpecFluent<A> {

    private List<CSINodeDriverBuilder> drivers =  new ArrayList<CSINodeDriverBuilder>();

    public CSINodeSpecFluentImpl() { 
    }


    public CSINodeSpecFluentImpl(CSINodeSpec instance) { 
        this.withDrivers(instance.getDrivers()); 
    }


    public A addToDrivers(int index,CSINodeDriver item) {
        if (this.drivers == null) {this.drivers = new ArrayList<CSINodeDriverBuilder>();}
        CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);_visitables.get("drivers").add(index >= 0 ? index : _visitables.get("drivers").size(), builder);this.drivers.add(index >= 0 ? index : drivers.size(), builder); return (A)this;
    }

    public A setToDrivers(int index,CSINodeDriver item) {
        if (this.drivers == null) {this.drivers = new ArrayList<CSINodeDriverBuilder>();}
        CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);
        if (index < 0 || index >= _visitables.get("drivers").size()) { _visitables.get("drivers").add(builder); } else { _visitables.get("drivers").set(index, builder);}
        if (index < 0 || index >= drivers.size()) { drivers.add(builder); } else { drivers.set(index, builder);}
         return (A)this;
    }

    public A addToDrivers(CSINodeDriver... items) {
        if (this.drivers == null) {this.drivers = new ArrayList<CSINodeDriverBuilder>();}
        for (CSINodeDriver item : items) {CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);_visitables.get("drivers").add(builder);this.drivers.add(builder);} return (A)this;
    }

    public A addAllToDrivers(Collection<CSINodeDriver> items) {
        if (this.drivers == null) {this.drivers = new ArrayList<CSINodeDriverBuilder>();}
        for (CSINodeDriver item : items) {CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);_visitables.get("drivers").add(builder);this.drivers.add(builder);} return (A)this;
    }

    public A removeFromDrivers(CSINodeDriver... items) {
        for (CSINodeDriver item : items) {CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);_visitables.get("drivers").remove(builder);if (this.drivers != null) {this.drivers.remove(builder);}} return (A)this;
    }

    public A removeAllFromDrivers(Collection<CSINodeDriver> items) {
        for (CSINodeDriver item : items) {CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);_visitables.get("drivers").remove(builder);if (this.drivers != null) {this.drivers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromDrivers(io.fabric8.kubernetes.api.builder.Predicate<CSINodeDriverBuilder> predicate) {
        if (drivers == null) return (A) this;
        final Iterator<CSINodeDriverBuilder> each = drivers.iterator();
        final List visitables = _visitables.get("drivers");
        while (each.hasNext()) {
          CSINodeDriverBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildDrivers instead.
 * @return The buildable object.
 */
@Deprecated public List<CSINodeDriver> getDrivers() {
        return build(drivers);
    }

    public List<CSINodeDriver> buildDrivers() {
        return build(drivers);
    }

    public CSINodeDriver buildDriver(int index) {
        return this.drivers.get(index).build();
    }

    public CSINodeDriver buildFirstDriver() {
        return this.drivers.get(0).build();
    }

    public CSINodeDriver buildLastDriver() {
        return this.drivers.get(drivers.size() - 1).build();
    }

    public CSINodeDriver buildMatchingDriver(io.fabric8.kubernetes.api.builder.Predicate<CSINodeDriverBuilder> predicate) {
        for (CSINodeDriverBuilder item: drivers) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingDriver(io.fabric8.kubernetes.api.builder.Predicate<CSINodeDriverBuilder> predicate) {
        for (CSINodeDriverBuilder item: drivers) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withDrivers(List<CSINodeDriver> drivers) {
        if (this.drivers != null) { _visitables.get("drivers").removeAll(this.drivers);}
        if (drivers != null) {this.drivers = new ArrayList<CSINodeDriverBuilder>(); for (CSINodeDriver item : drivers){this.addToDrivers(item);}} else { this.drivers = null;} return (A) this;
    }

    public A withDrivers(CSINodeDriver... drivers) {
        if (this.drivers != null) {this.drivers.clear();}
        if (drivers != null) {for (CSINodeDriver item :drivers){ this.addToDrivers(item);}} return (A) this;
    }

    public Boolean hasDrivers() {
        return drivers != null && !drivers.isEmpty();
    }

    public CSINodeSpecFluent.DriversNested<A> addNewDriver() {
        return new DriversNestedImpl();
    }

    public CSINodeSpecFluent.DriversNested<A> addNewDriverLike(CSINodeDriver item) {
        return new DriversNestedImpl(-1, item);
    }

    public CSINodeSpecFluent.DriversNested<A> setNewDriverLike(int index,CSINodeDriver item) {
        return new DriversNestedImpl(index, item);
    }

    public CSINodeSpecFluent.DriversNested<A> editDriver(int index) {
        if (drivers.size() <= index) throw new RuntimeException("Can't edit drivers. Index exceeds size.");
        return setNewDriverLike(index, buildDriver(index));
    }

    public CSINodeSpecFluent.DriversNested<A> editFirstDriver() {
        if (drivers.size() == 0) throw new RuntimeException("Can't edit first drivers. The list is empty.");
        return setNewDriverLike(0, buildDriver(0));
    }

    public CSINodeSpecFluent.DriversNested<A> editLastDriver() {
        int index = drivers.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last drivers. The list is empty.");
        return setNewDriverLike(index, buildDriver(index));
    }

    public CSINodeSpecFluent.DriversNested<A> editMatchingDriver(io.fabric8.kubernetes.api.builder.Predicate<CSINodeDriverBuilder> predicate) {
        int index = -1;
        for (int i=0;i<drivers.size();i++) { 
        if (predicate.apply(drivers.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching drivers. No match found.");
        return setNewDriverLike(index, buildDriver(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CSINodeSpecFluentImpl that = (CSINodeSpecFluentImpl) o;
        if (drivers != null ? !drivers.equals(that.drivers) :that.drivers != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(drivers,  super.hashCode());
    }

    public class DriversNestedImpl<N> extends CSINodeDriverFluentImpl<CSINodeSpecFluent.DriversNested<N>> implements CSINodeSpecFluent.DriversNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CSINodeDriverBuilder builder;
        private final int index;

        DriversNestedImpl(int index,CSINodeDriver item) {
            this.index = index;
            this.builder = new CSINodeDriverBuilder(this, item);
        }

        DriversNestedImpl() {
            this.index = -1;
            this.builder = new CSINodeDriverBuilder(this);
        }

        public N and() {
             return (N) CSINodeSpecFluentImpl.this.setToDrivers(index,builder.build());
        }

        public N endDriver() {
             return and();
        }
    }


}
