package io.fabric8.kubernetes.api.model.settings;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.EnvFromSource;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.Volume;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class PodPresetSpecFluentImpl<A extends PodPresetSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PodPresetSpecFluent<A> {

    private List<EnvVar> env = new ArrayList<EnvVar>();
    private List<EnvFromSource> envFrom = new ArrayList<EnvFromSource>();
    private LabelSelectorBuilder selector;
    private List<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
    private List<Volume> volumes = new ArrayList<Volume>();

    public PodPresetSpecFluentImpl() { 
    }


    public PodPresetSpecFluentImpl(PodPresetSpec instance) { 
        this.withEnv(instance.getEnv()); 
        this.withEnvFrom(instance.getEnvFrom()); 
        this.withSelector(instance.getSelector()); 
        this.withVolumeMounts(instance.getVolumeMounts()); 
        this.withVolumes(instance.getVolumes()); 
    }


    public A addToEnv(int index,EnvVar item) {
        if (this.env == null) {this.env = new ArrayList<EnvVar>();}
        this.env.add(index, item);
        return (A)this;
    }

    public A setToEnv(int index,EnvVar item) {
        if (this.env == null) {this.env = new ArrayList<EnvVar>();}
        this.env.set(index, item); return (A)this;
    }

    public A addToEnv(EnvVar... items) {
        if (this.env == null) {this.env = new ArrayList<EnvVar>();}
        for (EnvVar item : items) {this.env.add(item);} return (A)this;
    }

    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {this.env = new ArrayList<EnvVar>();}
        for (EnvVar item : items) {this.env.add(item);} return (A)this;
    }

    public A removeFromEnv(EnvVar... items) {
        for (EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
    }

    public A removeAllFromEnv(Collection<EnvVar> items) {
        for (EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
    }

    public List<EnvVar> getEnv() {
        return this.env;
    }

    public EnvVar getEnv(int index) {
        return this.env.get(index);
    }

    public EnvVar getFirstEnv() {
        return this.env.get(0);
    }

    public EnvVar getLastEnv() {
        return this.env.get(env.size() - 1);
    }

    public EnvVar getMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item: env) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item: env) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withEnv(List<EnvVar> env) {
        if (this.env != null) { _visitables.get("env").removeAll(this.env);}
        if (env != null) {this.env = new ArrayList<EnvVar>(); for (EnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
    }

    public A withEnv(EnvVar... env) {
        if (this.env != null) {this.env.clear();}
        if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (A) this;
    }

    public Boolean hasEnv() {
        return env != null && !env.isEmpty();
    }

    public A addToEnvFrom(int index,EnvFromSource item) {
        if (this.envFrom == null) {this.envFrom = new ArrayList<EnvFromSource>();}
        this.envFrom.add(index, item);
        return (A)this;
    }

    public A setToEnvFrom(int index,EnvFromSource item) {
        if (this.envFrom == null) {this.envFrom = new ArrayList<EnvFromSource>();}
        this.envFrom.set(index, item); return (A)this;
    }

    public A addToEnvFrom(EnvFromSource... items) {
        if (this.envFrom == null) {this.envFrom = new ArrayList<EnvFromSource>();}
        for (EnvFromSource item : items) {this.envFrom.add(item);} return (A)this;
    }

    public A addAllToEnvFrom(Collection<EnvFromSource> items) {
        if (this.envFrom == null) {this.envFrom = new ArrayList<EnvFromSource>();}
        for (EnvFromSource item : items) {this.envFrom.add(item);} return (A)this;
    }

    public A removeFromEnvFrom(EnvFromSource... items) {
        for (EnvFromSource item : items) {if (this.envFrom!= null){ this.envFrom.remove(item);}} return (A)this;
    }

    public A removeAllFromEnvFrom(Collection<EnvFromSource> items) {
        for (EnvFromSource item : items) {if (this.envFrom!= null){ this.envFrom.remove(item);}} return (A)this;
    }

    public List<EnvFromSource> getEnvFrom() {
        return this.envFrom;
    }

    public EnvFromSource getEnvFrom(int index) {
        return this.envFrom.get(index);
    }

    public EnvFromSource getFirstEnvFrom() {
        return this.envFrom.get(0);
    }

    public EnvFromSource getLastEnvFrom() {
        return this.envFrom.get(envFrom.size() - 1);
    }

    public EnvFromSource getMatchingEnvFrom(Predicate<EnvFromSource> predicate) {
        for (EnvFromSource item: envFrom) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingEnvFrom(Predicate<EnvFromSource> predicate) {
        for (EnvFromSource item: envFrom) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withEnvFrom(List<EnvFromSource> envFrom) {
        if (this.envFrom != null) { _visitables.get("envFrom").removeAll(this.envFrom);}
        if (envFrom != null) {this.envFrom = new ArrayList<EnvFromSource>(); for (EnvFromSource item : envFrom){this.addToEnvFrom(item);}} else { this.envFrom = null;} return (A) this;
    }

    public A withEnvFrom(EnvFromSource... envFrom) {
        if (this.envFrom != null) {this.envFrom.clear();}
        if (envFrom != null) {for (EnvFromSource item :envFrom){ this.addToEnvFrom(item);}} return (A) this;
    }

    public Boolean hasEnvFrom() {
        return envFrom != null && !envFrom.isEmpty();
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public LabelSelector buildSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(LabelSelector selector) {
        _visitables.get("selector").remove(this.selector);
        if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector() {
        return this.selector != null;
    }

    public PodPresetSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    public PodPresetSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    public PodPresetSpecFluent.SelectorNested<A> editSelector() {
        return withNewSelectorLike(getSelector());
    }

    public PodPresetSpecFluent.SelectorNested<A> editOrNewSelector() {
        return withNewSelectorLike(getSelector() != null ? getSelector(): new LabelSelectorBuilder().build());
    }

    public PodPresetSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public A addToVolumeMounts(int index,VolumeMount item) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
        this.volumeMounts.add(index, item);
        return (A)this;
    }

    public A setToVolumeMounts(int index,VolumeMount item) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
        this.volumeMounts.set(index, item); return (A)this;
    }

    public A addToVolumeMounts(VolumeMount... items) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
        for (VolumeMount item : items) {this.volumeMounts.add(item);} return (A)this;
    }

    public A addAllToVolumeMounts(Collection<VolumeMount> items) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
        for (VolumeMount item : items) {this.volumeMounts.add(item);} return (A)this;
    }

    public A removeFromVolumeMounts(VolumeMount... items) {
        for (VolumeMount item : items) {if (this.volumeMounts!= null){ this.volumeMounts.remove(item);}} return (A)this;
    }

    public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
        for (VolumeMount item : items) {if (this.volumeMounts!= null){ this.volumeMounts.remove(item);}} return (A)this;
    }

    public List<VolumeMount> getVolumeMounts() {
        return this.volumeMounts;
    }

    public VolumeMount getVolumeMount(int index) {
        return this.volumeMounts.get(index);
    }

    public VolumeMount getFirstVolumeMount() {
        return this.volumeMounts.get(0);
    }

    public VolumeMount getLastVolumeMount() {
        return this.volumeMounts.get(volumeMounts.size() - 1);
    }

    public VolumeMount getMatchingVolumeMount(Predicate<VolumeMount> predicate) {
        for (VolumeMount item: volumeMounts) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingVolumeMount(Predicate<VolumeMount> predicate) {
        for (VolumeMount item: volumeMounts) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withVolumeMounts(List<VolumeMount> volumeMounts) {
        if (this.volumeMounts != null) { _visitables.get("volumeMounts").removeAll(this.volumeMounts);}
        if (volumeMounts != null) {this.volumeMounts = new ArrayList<VolumeMount>(); for (VolumeMount item : volumeMounts){this.addToVolumeMounts(item);}} else { this.volumeMounts = null;} return (A) this;
    }

    public A withVolumeMounts(VolumeMount... volumeMounts) {
        if (this.volumeMounts != null) {this.volumeMounts.clear();}
        if (volumeMounts != null) {for (VolumeMount item :volumeMounts){ this.addToVolumeMounts(item);}} return (A) this;
    }

    public Boolean hasVolumeMounts() {
        return volumeMounts != null && !volumeMounts.isEmpty();
    }

    public A addToVolumes(int index,Volume item) {
        if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
        this.volumes.add(index, item);
        return (A)this;
    }

    public A setToVolumes(int index,Volume item) {
        if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
        this.volumes.set(index, item); return (A)this;
    }

    public A addToVolumes(Volume... items) {
        if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
        for (Volume item : items) {this.volumes.add(item);} return (A)this;
    }

    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
        for (Volume item : items) {this.volumes.add(item);} return (A)this;
    }

    public A removeFromVolumes(Volume... items) {
        for (Volume item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
    }

    public A removeAllFromVolumes(Collection<Volume> items) {
        for (Volume item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
    }

    public List<Volume> getVolumes() {
        return this.volumes;
    }

    public Volume getVolume(int index) {
        return this.volumes.get(index);
    }

    public Volume getFirstVolume() {
        return this.volumes.get(0);
    }

    public Volume getLastVolume() {
        return this.volumes.get(volumes.size() - 1);
    }

    public Volume getMatchingVolume(Predicate<Volume> predicate) {
        for (Volume item: volumes) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingVolume(Predicate<Volume> predicate) {
        for (Volume item: volumes) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) { _visitables.get("volumes").removeAll(this.volumes);}
        if (volumes != null) {this.volumes = new ArrayList<Volume>(); for (Volume item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
    }

    public A withVolumes(Volume... volumes) {
        if (this.volumes != null) {this.volumes.clear();}
        if (volumes != null) {for (Volume item :volumes){ this.addToVolumes(item);}} return (A) this;
    }

    public Boolean hasVolumes() {
        return volumes != null && !volumes.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PodPresetSpecFluentImpl that = (PodPresetSpecFluentImpl) o;
        if (env != null ? !env.equals(that.env) :that.env != null) return false;
        if (envFrom != null ? !envFrom.equals(that.envFrom) :that.envFrom != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        if (volumeMounts != null ? !volumeMounts.equals(that.volumeMounts) :that.volumeMounts != null) return false;
        if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(env,  envFrom,  selector,  volumeMounts,  volumes,  super.hashCode());
    }

    public class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<PodPresetSpecFluent.SelectorNested<N>> implements PodPresetSpecFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorBuilder builder;

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        public N and() {
             return (N) PodPresetSpecFluentImpl.this.withSelector(builder.build());
        }

        public N endSelector() {
             return and();
        }
    }


}
