package io.fabric8.kubernetes.api.model.scheduling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PriorityClassListBuilder extends PriorityClassListFluentImpl<PriorityClassListBuilder> implements VisitableBuilder<PriorityClassList,io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClassListBuilder>{
  public PriorityClassListBuilder() {
    this(false);
  }
  public PriorityClassListBuilder(Boolean validationEnabled) {
    this(new PriorityClassList(), validationEnabled);
  }
  public PriorityClassListBuilder(PriorityClassListFluent<?> fluent) {
    this(fluent, false);
  }
  public PriorityClassListBuilder(io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClassListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PriorityClassList(), validationEnabled);
  }
  public PriorityClassListBuilder(io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClassListFluent<?> fluent,io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClassList instance) {
    this(fluent, instance, false);
  }
  public PriorityClassListBuilder(io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClassListFluent<?> fluent,io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClassList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PriorityClassListBuilder(io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClassList instance) {
    this(instance,false);
  }
  public PriorityClassListBuilder(io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClassList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClassListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClassList build() {
    PriorityClassList buildable = new PriorityClassList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}