package io.fabric8.kubernetes.api.model.scheduling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PriorityClassBuilder extends io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClassFluentImpl<io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClassBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClass,io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClassBuilder> {

    io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClassFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public PriorityClassBuilder() {
        this(true);
    }

    public PriorityClassBuilder(java.lang.Boolean validationEnabled) {
        this(new PriorityClass(), validationEnabled);
    }

    public PriorityClassBuilder(io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClassFluent<?> fluent) {
        this(fluent, true);
    }

    public PriorityClassBuilder(io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClassFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new PriorityClass(), validationEnabled);
    }

    public PriorityClassBuilder(io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClassFluent<?> fluent,io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClass instance) {
        this(fluent, instance, true);
    }

    public PriorityClassBuilder(io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClassFluent<?> fluent,io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClass instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withDescription(instance.getDescription()); 
        fluent.withGlobalDefault(instance.getGlobalDefault()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withPreemptionPolicy(instance.getPreemptionPolicy()); 
        fluent.withValue(instance.getValue()); 
        this.validationEnabled = validationEnabled; 
    }

    public PriorityClassBuilder(io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClass instance) {
        this(instance,true);
    }

    public PriorityClassBuilder(io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClass instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withDescription(instance.getDescription()); 
        this.withGlobalDefault(instance.getGlobalDefault()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withPreemptionPolicy(instance.getPreemptionPolicy()); 
        this.withValue(instance.getValue()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClass build() {
        PriorityClass buildable = new PriorityClass(fluent.getApiVersion(),fluent.getDescription(),fluent.getGlobalDefault(),fluent.getKind(),fluent.getMetadata(),fluent.getPreemptionPolicy(),fluent.getValue());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PriorityClassBuilder that = (PriorityClassBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
