package io.fabric8.kubernetes.api.model.scheduling;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class PriorityClassFluentImpl<A extends PriorityClassFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PriorityClassFluent<A> {

    private String apiVersion;
    private String description;
    private Boolean globalDefault;
    private String kind;
    private ObjectMetaBuilder metadata;
    private String preemptionPolicy;
    private Integer value;

    public PriorityClassFluentImpl() {
    }

    public PriorityClassFluentImpl(PriorityClass instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withDescription(instance.getDescription()); 
        this.withGlobalDefault(instance.getGlobalDefault()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withPreemptionPolicy(instance.getPreemptionPolicy()); 
        this.withValue(instance.getValue()); 
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getDescription() {
        return this.description;
    }

    public A withDescription(String description) {
        this.description=description; return (A) this;
    }

    public Boolean hasDescription() {
        return this.description != null;
    }

    public A withNewDescription(String arg1) {
        return (A)withDescription(new String(arg1));
    }

    public A withNewDescription(StringBuilder arg1) {
        return (A)withDescription(new String(arg1));
    }

    public A withNewDescription(StringBuffer arg1) {
        return (A)withDescription(new String(arg1));
    }

    public Boolean isGlobalDefault() {
        return this.globalDefault;
    }

    public A withGlobalDefault(Boolean globalDefault) {
        this.globalDefault=globalDefault; return (A) this;
    }

    public Boolean hasGlobalDefault() {
        return this.globalDefault != null;
    }

    public A withNewGlobalDefault(String arg1) {
        return (A)withGlobalDefault(new Boolean(arg1));
    }

    public A withNewGlobalDefault(boolean arg1) {
        return (A)withGlobalDefault(new Boolean(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public PriorityClassFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public PriorityClassFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    public PriorityClassFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public PriorityClassFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public PriorityClassFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public String getPreemptionPolicy() {
        return this.preemptionPolicy;
    }

    public A withPreemptionPolicy(String preemptionPolicy) {
        this.preemptionPolicy=preemptionPolicy; return (A) this;
    }

    public Boolean hasPreemptionPolicy() {
        return this.preemptionPolicy != null;
    }

    public A withNewPreemptionPolicy(String arg1) {
        return (A)withPreemptionPolicy(new String(arg1));
    }

    public A withNewPreemptionPolicy(StringBuilder arg1) {
        return (A)withPreemptionPolicy(new String(arg1));
    }

    public A withNewPreemptionPolicy(StringBuffer arg1) {
        return (A)withPreemptionPolicy(new String(arg1));
    }

    public Integer getValue() {
        return this.value;
    }

    public A withValue(Integer value) {
        this.value=value; return (A) this;
    }

    public Boolean hasValue() {
        return this.value != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PriorityClassFluentImpl that = (PriorityClassFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (description != null ? !description.equals(that.description) :that.description != null) return false;
        if (globalDefault != null ? !globalDefault.equals(that.globalDefault) :that.globalDefault != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (preemptionPolicy != null ? !preemptionPolicy.equals(that.preemptionPolicy) :that.preemptionPolicy != null) return false;
        if (value != null ? !value.equals(that.value) :that.value != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  description,  globalDefault,  kind,  metadata,  preemptionPolicy,  value,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<PriorityClassFluent.MetadataNested<N>> implements PriorityClassFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectMetaBuilder builder;

            MetadataNestedImpl(ObjectMeta item) {
                this.builder = new ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) PriorityClassFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


}
