package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceClaimTemplateListBuilder extends ResourceClaimTemplateListFluent<ResourceClaimTemplateListBuilder> implements VisitableBuilder<ResourceClaimTemplateList,ResourceClaimTemplateListBuilder>{
  public ResourceClaimTemplateListBuilder() {
    this(false);
  }
  public ResourceClaimTemplateListBuilder(Boolean validationEnabled) {
    this(new ResourceClaimTemplateList(), validationEnabled);
  }
  public ResourceClaimTemplateListBuilder(ResourceClaimTemplateListFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceClaimTemplateListBuilder(ResourceClaimTemplateListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceClaimTemplateList(), validationEnabled);
  }
  public ResourceClaimTemplateListBuilder(ResourceClaimTemplateListFluent<?> fluent,ResourceClaimTemplateList instance) {
    this(fluent, instance, false);
  }
  public ResourceClaimTemplateListBuilder(ResourceClaimTemplateListFluent<?> fluent,ResourceClaimTemplateList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ResourceClaimTemplateList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourceClaimTemplateListBuilder(ResourceClaimTemplateList instance) {
    this(instance,false);
  }
  public ResourceClaimTemplateListBuilder(ResourceClaimTemplateList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ResourceClaimTemplateList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourceClaimTemplateListFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceClaimTemplateList build() {
    ResourceClaimTemplateList buildable = new ResourceClaimTemplateList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}