package io.fabric8.kubernetes.api.model.resource.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodSchedulingSpecBuilder extends PodSchedulingSpecFluentImpl<PodSchedulingSpecBuilder> implements VisitableBuilder<PodSchedulingSpec,PodSchedulingSpecBuilder>{
  public PodSchedulingSpecBuilder() {
    this(false);
  }
  public PodSchedulingSpecBuilder(Boolean validationEnabled) {
    this(new PodSchedulingSpec(), validationEnabled);
  }
  public PodSchedulingSpecBuilder(PodSchedulingSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSchedulingSpecBuilder(PodSchedulingSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodSchedulingSpec(), validationEnabled);
  }
  public PodSchedulingSpecBuilder(PodSchedulingSpecFluent<?> fluent,PodSchedulingSpec instance) {
    this(fluent, instance, false);
  }
  public PodSchedulingSpecBuilder(PodSchedulingSpecFluent<?> fluent,PodSchedulingSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withPotentialNodes(instance.getPotentialNodes());
      fluent.withSelectedNode(instance.getSelectedNode());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodSchedulingSpecBuilder(PodSchedulingSpec instance) {
    this(instance,false);
  }
  public PodSchedulingSpecBuilder(PodSchedulingSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withPotentialNodes(instance.getPotentialNodes());
      this.withSelectedNode(instance.getSelectedNode());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodSchedulingSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PodSchedulingSpec build() {
    PodSchedulingSpec buildable = new PodSchedulingSpec(fluent.getPotentialNodes(),fluent.getSelectedNode());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}