package io.fabric8.kubernetes.api.model.resource.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodSchedulingListBuilder extends PodSchedulingListFluentImpl<PodSchedulingListBuilder> implements VisitableBuilder<PodSchedulingList,PodSchedulingListBuilder>{
  public PodSchedulingListBuilder() {
    this(false);
  }
  public PodSchedulingListBuilder(Boolean validationEnabled) {
    this(new PodSchedulingList(), validationEnabled);
  }
  public PodSchedulingListBuilder(PodSchedulingListFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSchedulingListBuilder(PodSchedulingListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodSchedulingList(), validationEnabled);
  }
  public PodSchedulingListBuilder(PodSchedulingListFluent<?> fluent,PodSchedulingList instance) {
    this(fluent, instance, false);
  }
  public PodSchedulingListBuilder(PodSchedulingListFluent<?> fluent,PodSchedulingList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodSchedulingListBuilder(PodSchedulingList instance) {
    this(instance,false);
  }
  public PodSchedulingListBuilder(PodSchedulingList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodSchedulingListFluent<?> fluent;
  Boolean validationEnabled;
  public PodSchedulingList build() {
    PodSchedulingList buildable = new PodSchedulingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}