package io.fabric8.kubernetes.api.model.resource.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ResourceClassListFluent<A extends ResourceClassListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(int index,ResourceClass item);
  public A setToItems(int index,ResourceClass item);
  public A addToItems(io.fabric8.kubernetes.api.model.resource.v1alpha1.ResourceClass... items);
  public A addAllToItems(Collection<ResourceClass> items);
  public A removeFromItems(io.fabric8.kubernetes.api.model.resource.v1alpha1.ResourceClass... items);
  public A removeAllFromItems(Collection<ResourceClass> items);
  public A removeMatchingFromItems(Predicate<ResourceClassBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ResourceClass> getItems();
  public List<ResourceClass> buildItems();
  public ResourceClass buildItem(int index);
  public ResourceClass buildFirstItem();
  public ResourceClass buildLastItem();
  public ResourceClass buildMatchingItem(Predicate<ResourceClassBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<ResourceClassBuilder> predicate);
  public A withItems(List<ResourceClass> items);
  public A withItems(io.fabric8.kubernetes.api.model.resource.v1alpha1.ResourceClass... items);
  public Boolean hasItems();
  public ResourceClassListFluent.ItemsNested<A> addNewItem();
  public ResourceClassListFluent.ItemsNested<A> addNewItemLike(ResourceClass item);
  public ResourceClassListFluent.ItemsNested<A> setNewItemLike(int index,ResourceClass item);
  public ResourceClassListFluent.ItemsNested<A> editItem(int index);
  public ResourceClassListFluent.ItemsNested<A> editFirstItem();
  public ResourceClassListFluent.ItemsNested<A> editLastItem();
  public ResourceClassListFluent.ItemsNested<A> editMatchingItem(Predicate<ResourceClassBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public ListMeta getMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,ResourceClassFluent<ResourceClassListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  
}