package io.fabric8.kubernetes.api.model.resource.v1alpha1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.NodeSelector;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ResourceClassFluentImpl<A extends ResourceClassFluent<A>> extends BaseFluent<A> implements ResourceClassFluent<A>{
  public ResourceClassFluentImpl() {
  }
  public ResourceClassFluentImpl(ResourceClass instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withDriverName(instance.getDriverName());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withParametersRef(instance.getParametersRef());
      this.withSuitableNodes(instance.getSuitableNodes());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private String driverName;
  private String kind;
  private ObjectMetaBuilder metadata;
  private ResourceClassParametersReferenceBuilder parametersRef;
  private NodeSelector suitableNodes;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getDriverName() {
    return this.driverName;
  }
  public A withDriverName(String driverName) {
    this.driverName=driverName; return (A) this;
  }
  public Boolean hasDriverName() {
    return this.driverName != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ResourceClassFluentImpl.MetadataNested<A> withNewMetadata() {
    return new ResourceClassFluentImpl.MetadataNestedImpl();
  }
  public ResourceClassFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new ResourceClassFluentImpl.MetadataNestedImpl(item);
  }
  public ResourceClassFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public ResourceClassFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public ResourceClassFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildParametersRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceClassParametersReference getParametersRef() {
    return this.parametersRef!=null ?this.parametersRef.build():null;
  }
  public ResourceClassParametersReference buildParametersRef() {
    return this.parametersRef!=null ?this.parametersRef.build():null;
  }
  public A withParametersRef(ResourceClassParametersReference parametersRef) {
    _visitables.get("parametersRef").remove(this.parametersRef);
    if (parametersRef!=null){ this.parametersRef= new ResourceClassParametersReferenceBuilder(parametersRef); _visitables.get("parametersRef").add(this.parametersRef);} else { this.parametersRef = null; _visitables.get("parametersRef").remove(this.parametersRef); } return (A) this;
  }
  public Boolean hasParametersRef() {
    return this.parametersRef != null;
  }
  public A withNewParametersRef(String apiGroup,String kind,String name,String namespace) {
    return (A)withParametersRef(new ResourceClassParametersReference(apiGroup, kind, name, namespace));
  }
  public ResourceClassFluentImpl.ParametersRefNested<A> withNewParametersRef() {
    return new ResourceClassFluentImpl.ParametersRefNestedImpl();
  }
  public ResourceClassFluentImpl.ParametersRefNested<A> withNewParametersRefLike(ResourceClassParametersReference item) {
    return new ResourceClassFluentImpl.ParametersRefNestedImpl(item);
  }
  public ResourceClassFluentImpl.ParametersRefNested<A> editParametersRef() {
    return withNewParametersRefLike(getParametersRef());
  }
  public ResourceClassFluentImpl.ParametersRefNested<A> editOrNewParametersRef() {
    return withNewParametersRefLike(getParametersRef() != null ? getParametersRef(): new ResourceClassParametersReferenceBuilder().build());
  }
  public ResourceClassFluentImpl.ParametersRefNested<A> editOrNewParametersRefLike(ResourceClassParametersReference item) {
    return withNewParametersRefLike(getParametersRef() != null ? getParametersRef(): item);
  }
  public NodeSelector getSuitableNodes() {
    return this.suitableNodes;
  }
  public A withSuitableNodes(NodeSelector suitableNodes) {
    this.suitableNodes=suitableNodes; return (A) this;
  }
  public Boolean hasSuitableNodes() {
    return this.suitableNodes != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ResourceClassFluentImpl that = (ResourceClassFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(driverName, that.driverName)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(parametersRef, that.parametersRef)) return false;

    if (!java.util.Objects.equals(suitableNodes, that.suitableNodes)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  driverName,  kind,  metadata,  parametersRef,  suitableNodes,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (driverName != null) { sb.append("driverName:"); sb.append(driverName + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (parametersRef != null) { sb.append("parametersRef:"); sb.append(parametersRef + ","); }
    if (suitableNodes != null) { sb.append("suitableNodes:"); sb.append(suitableNodes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ResourceClassFluentImpl.MetadataNested<N>> implements ResourceClassFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ResourceClassFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class ParametersRefNestedImpl<N> extends ResourceClassParametersReferenceFluentImpl<ResourceClassFluentImpl.ParametersRefNested<N>> implements ResourceClassFluentImpl.ParametersRefNested<N>,Nested<N>{
    ParametersRefNestedImpl(ResourceClassParametersReference item) {
      this.builder = new ResourceClassParametersReferenceBuilder(this, item);
    }
    ParametersRefNestedImpl() {
      this.builder = new ResourceClassParametersReferenceBuilder(this);
    }
    ResourceClassParametersReferenceBuilder builder;
    public N and() {
      return (N) ResourceClassFluentImpl.this.withParametersRef(builder.build());
    }
    public N endParametersRef() {
      return and();
    }
    
  }
  
}