package io.fabric8.kubernetes.api.model.resource.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceClaimListBuilder extends ResourceClaimListFluentImpl<ResourceClaimListBuilder> implements VisitableBuilder<ResourceClaimList,ResourceClaimListBuilder>{
  public ResourceClaimListBuilder() {
    this(false);
  }
  public ResourceClaimListBuilder(Boolean validationEnabled) {
    this(new ResourceClaimList(), validationEnabled);
  }
  public ResourceClaimListBuilder(ResourceClaimListFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceClaimListBuilder(ResourceClaimListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceClaimList(), validationEnabled);
  }
  public ResourceClaimListBuilder(ResourceClaimListFluent<?> fluent,ResourceClaimList instance) {
    this(fluent, instance, false);
  }
  public ResourceClaimListBuilder(ResourceClaimListFluent<?> fluent,ResourceClaimList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourceClaimListBuilder(ResourceClaimList instance) {
    this(instance,false);
  }
  public ResourceClaimListBuilder(ResourceClaimList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourceClaimListFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceClaimList build() {
    ResourceClaimList buildable = new ResourceClaimList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}