package io.fabric8.kubernetes.api.model.resource.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceClassBuilder extends ResourceClassFluentImpl<ResourceClassBuilder> implements VisitableBuilder<ResourceClass,ResourceClassBuilder>{
  public ResourceClassBuilder() {
    this(false);
  }
  public ResourceClassBuilder(Boolean validationEnabled) {
    this(new ResourceClass(), validationEnabled);
  }
  public ResourceClassBuilder(ResourceClassFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceClassBuilder(ResourceClassFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceClass(), validationEnabled);
  }
  public ResourceClassBuilder(ResourceClassFluent<?> fluent,ResourceClass instance) {
    this(fluent, instance, false);
  }
  public ResourceClassBuilder(ResourceClassFluent<?> fluent,ResourceClass instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withDriverName(instance.getDriverName()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withParametersRef(instance.getParametersRef()); 
    fluent.withSuitableNodes(instance.getSuitableNodes()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ResourceClassBuilder(ResourceClass instance) {
    this(instance,false);
  }
  public ResourceClassBuilder(ResourceClass instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withDriverName(instance.getDriverName()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withParametersRef(instance.getParametersRef()); 
    this.withSuitableNodes(instance.getSuitableNodes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ResourceClassFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceClass build() {
    ResourceClass buildable = new ResourceClass(fluent.getApiVersion(),fluent.getDriverName(),fluent.getKind(),fluent.getMetadata(),fluent.getParametersRef(),fluent.getSuitableNodes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}