package io.fabric8.kubernetes.api.model.resource.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceClaimSpecBuilder extends ResourceClaimSpecFluentImpl<ResourceClaimSpecBuilder> implements VisitableBuilder<ResourceClaimSpec,ResourceClaimSpecBuilder>{
  public ResourceClaimSpecBuilder() {
    this(false);
  }
  public ResourceClaimSpecBuilder(Boolean validationEnabled) {
    this(new ResourceClaimSpec(), validationEnabled);
  }
  public ResourceClaimSpecBuilder(ResourceClaimSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceClaimSpecBuilder(ResourceClaimSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceClaimSpec(), validationEnabled);
  }
  public ResourceClaimSpecBuilder(ResourceClaimSpecFluent<?> fluent,ResourceClaimSpec instance) {
    this(fluent, instance, false);
  }
  public ResourceClaimSpecBuilder(ResourceClaimSpecFluent<?> fluent,ResourceClaimSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAllocationMode(instance.getAllocationMode()); 
    fluent.withParametersRef(instance.getParametersRef()); 
    fluent.withResourceClassName(instance.getResourceClassName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ResourceClaimSpecBuilder(ResourceClaimSpec instance) {
    this(instance,false);
  }
  public ResourceClaimSpecBuilder(ResourceClaimSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAllocationMode(instance.getAllocationMode()); 
    this.withParametersRef(instance.getParametersRef()); 
    this.withResourceClassName(instance.getResourceClassName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ResourceClaimSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceClaimSpec build() {
    ResourceClaimSpec buildable = new ResourceClaimSpec(fluent.getAllocationMode(),fluent.getParametersRef(),fluent.getResourceClassName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}