package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NamedResourcesAttributeFluent<A extends NamedResourcesAttributeFluent<A>> extends BaseFluent<A>{
  public NamedResourcesAttributeFluent() {
  }
  
  public NamedResourcesAttributeFluent(NamedResourcesAttribute instance) {
    this.copyInstance(instance);
  }
  private Boolean bool;
  private Long _int;
  private NamedResourcesIntSliceBuilder intSlice;
  private String name;
  private Quantity quantity;
  private String string;
  private NamedResourcesStringSliceBuilder stringSlice;
  private String version;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NamedResourcesAttribute instance) {
    instance = (instance != null ? instance : new NamedResourcesAttribute());
    if (instance != null) {
          this.withBool(instance.getBool());
          this.withInt(instance.getInt());
          this.withIntSlice(instance.getIntSlice());
          this.withName(instance.getName());
          this.withQuantity(instance.getQuantity());
          this.withString(instance.getString());
          this.withStringSlice(instance.getStringSlice());
          this.withVersion(instance.getVersion());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Boolean getBool() {
    return this.bool;
  }
  
  public A withBool(Boolean bool) {
    this.bool = bool;
    return (A) this;
  }
  
  public boolean hasBool() {
    return this.bool != null;
  }
  
  public Long getInt() {
    return this._int;
  }
  
  public A withInt(Long _int) {
    this._int = _int;
    return (A) this;
  }
  
  public boolean hasInt() {
    return this._int != null;
  }
  
  public NamedResourcesIntSlice buildIntSlice() {
    return this.intSlice != null ? this.intSlice.build() : null;
  }
  
  public A withIntSlice(NamedResourcesIntSlice intSlice) {
    this._visitables.remove("intSlice");
    if (intSlice != null) {
        this.intSlice = new NamedResourcesIntSliceBuilder(intSlice);
        this._visitables.get("intSlice").add(this.intSlice);
    } else {
        this.intSlice = null;
        this._visitables.get("intSlice").remove(this.intSlice);
    }
    return (A) this;
  }
  
  public boolean hasIntSlice() {
    return this.intSlice != null;
  }
  
  public IntSliceNested<A> withNewIntSlice() {
    return new IntSliceNested(null);
  }
  
  public IntSliceNested<A> withNewIntSliceLike(NamedResourcesIntSlice item) {
    return new IntSliceNested(item);
  }
  
  public IntSliceNested<A> editIntSlice() {
    return withNewIntSliceLike(java.util.Optional.ofNullable(buildIntSlice()).orElse(null));
  }
  
  public IntSliceNested<A> editOrNewIntSlice() {
    return withNewIntSliceLike(java.util.Optional.ofNullable(buildIntSlice()).orElse(new NamedResourcesIntSliceBuilder().build()));
  }
  
  public IntSliceNested<A> editOrNewIntSliceLike(NamedResourcesIntSlice item) {
    return withNewIntSliceLike(java.util.Optional.ofNullable(buildIntSlice()).orElse(item));
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public Quantity getQuantity() {
    return this.quantity;
  }
  
  public A withQuantity(Quantity quantity) {
    this.quantity = quantity;
    return (A) this;
  }
  
  public boolean hasQuantity() {
    return this.quantity != null;
  }
  
  public A withNewQuantity(String amount,String format) {
    return (A)withQuantity(new Quantity(amount, format));
  }
  
  public A withNewQuantity(String amount) {
    return (A)withQuantity(new Quantity(amount));
  }
  
  public String getString() {
    return this.string;
  }
  
  public A withString(String string) {
    this.string = string;
    return (A) this;
  }
  
  public boolean hasString() {
    return this.string != null;
  }
  
  public NamedResourcesStringSlice buildStringSlice() {
    return this.stringSlice != null ? this.stringSlice.build() : null;
  }
  
  public A withStringSlice(NamedResourcesStringSlice stringSlice) {
    this._visitables.remove("stringSlice");
    if (stringSlice != null) {
        this.stringSlice = new NamedResourcesStringSliceBuilder(stringSlice);
        this._visitables.get("stringSlice").add(this.stringSlice);
    } else {
        this.stringSlice = null;
        this._visitables.get("stringSlice").remove(this.stringSlice);
    }
    return (A) this;
  }
  
  public boolean hasStringSlice() {
    return this.stringSlice != null;
  }
  
  public StringSliceNested<A> withNewStringSlice() {
    return new StringSliceNested(null);
  }
  
  public StringSliceNested<A> withNewStringSliceLike(NamedResourcesStringSlice item) {
    return new StringSliceNested(item);
  }
  
  public StringSliceNested<A> editStringSlice() {
    return withNewStringSliceLike(java.util.Optional.ofNullable(buildStringSlice()).orElse(null));
  }
  
  public StringSliceNested<A> editOrNewStringSlice() {
    return withNewStringSliceLike(java.util.Optional.ofNullable(buildStringSlice()).orElse(new NamedResourcesStringSliceBuilder().build()));
  }
  
  public StringSliceNested<A> editOrNewStringSliceLike(NamedResourcesStringSlice item) {
    return withNewStringSliceLike(java.util.Optional.ofNullable(buildStringSlice()).orElse(item));
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public A withVersion(String version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NamedResourcesAttributeFluent that = (NamedResourcesAttributeFluent) o;
    if (!java.util.Objects.equals(bool, that.bool)) return false;
    if (!java.util.Objects.equals(_int, that._int)) return false;
    if (!java.util.Objects.equals(intSlice, that.intSlice)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(quantity, that.quantity)) return false;
    if (!java.util.Objects.equals(string, that.string)) return false;
    if (!java.util.Objects.equals(stringSlice, that.stringSlice)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(bool,  _int,  intSlice,  name,  quantity,  string,  stringSlice,  version,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bool != null) { sb.append("bool:"); sb.append(bool + ","); }
    if (_int != null) { sb.append("_int:"); sb.append(_int + ","); }
    if (intSlice != null) { sb.append("intSlice:"); sb.append(intSlice + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (quantity != null) { sb.append("quantity:"); sb.append(quantity + ","); }
    if (string != null) { sb.append("string:"); sb.append(string + ","); }
    if (stringSlice != null) { sb.append("stringSlice:"); sb.append(stringSlice + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withBool() {
    return withBool(true);
  }
  public class IntSliceNested<N> extends NamedResourcesIntSliceFluent<IntSliceNested<N>> implements Nested<N>{
    IntSliceNested(NamedResourcesIntSlice item) {
      this.builder = new NamedResourcesIntSliceBuilder(this, item);
    }
    NamedResourcesIntSliceBuilder builder;
    
    public N and() {
      return (N) NamedResourcesAttributeFluent.this.withIntSlice(builder.build());
    }
    
    public N endIntSlice() {
      return and();
    }
    
  
  }
  public class StringSliceNested<N> extends NamedResourcesStringSliceFluent<StringSliceNested<N>> implements Nested<N>{
    StringSliceNested(NamedResourcesStringSlice item) {
      this.builder = new NamedResourcesStringSliceBuilder(this, item);
    }
    NamedResourcesStringSliceBuilder builder;
    
    public N and() {
      return (N) NamedResourcesAttributeFluent.this.withStringSlice(builder.build());
    }
    
    public N endStringSlice() {
      return and();
    }
    
  
  }

}