package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RoleBindingListBuilder extends RoleBindingListFluent<RoleBindingListBuilder> implements VisitableBuilder<RoleBindingList,RoleBindingListBuilder>{
  public RoleBindingListBuilder() {
    this(false);
  }
  public RoleBindingListBuilder(Boolean validationEnabled) {
    this(new RoleBindingList(), validationEnabled);
  }
  public RoleBindingListBuilder(RoleBindingListFluent<?> fluent) {
    this(fluent, false);
  }
  public RoleBindingListBuilder(RoleBindingListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RoleBindingList(), validationEnabled);
  }
  public RoleBindingListBuilder(RoleBindingListFluent<?> fluent,RoleBindingList instance) {
    this(fluent, instance, false);
  }
  public RoleBindingListBuilder(RoleBindingListFluent<?> fluent,RoleBindingList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RoleBindingList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RoleBindingListBuilder(RoleBindingList instance) {
    this(instance,false);
  }
  public RoleBindingListBuilder(RoleBindingList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RoleBindingList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RoleBindingListFluent<?> fluent;
  Boolean validationEnabled;
  public RoleBindingList build() {
    RoleBindingList buildable = new RoleBindingList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}