package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterRoleBuilder extends ClusterRoleFluent<ClusterRoleBuilder> implements VisitableBuilder<ClusterRole,ClusterRoleBuilder>{
  public ClusterRoleBuilder() {
    this(false);
  }
  public ClusterRoleBuilder(Boolean validationEnabled) {
    this(new ClusterRole(), validationEnabled);
  }
  public ClusterRoleBuilder(ClusterRoleFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterRoleBuilder(ClusterRoleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterRole(), validationEnabled);
  }
  public ClusterRoleBuilder(ClusterRoleFluent<?> fluent,ClusterRole instance) {
    this(fluent, instance, false);
  }
  public ClusterRoleBuilder(ClusterRoleFluent<?> fluent,ClusterRole instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterRole());

    if (instance != null) {
      fluent.withAggregationRule(instance.getAggregationRule());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withRules(instance.getRules());
      fluent.withAggregationRule(instance.getAggregationRule());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withRules(instance.getRules());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterRoleBuilder(ClusterRole instance) {
    this(instance,false);
  }
  public ClusterRoleBuilder(ClusterRole instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterRole());

    if (instance != null) {
      this.withAggregationRule(instance.getAggregationRule());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withRules(instance.getRules());
      this.withAggregationRule(instance.getAggregationRule());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withRules(instance.getRules());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterRoleFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterRole build() {
    ClusterRole buildable = new ClusterRole(fluent.buildAggregationRule(),fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildRules());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}