package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class AggregationRuleFluentImpl<A extends AggregationRuleFluent<A>> extends BaseFluent<A> implements AggregationRuleFluent<A>{
  public AggregationRuleFluentImpl() {
  }
  public AggregationRuleFluentImpl(AggregationRule instance) {
    if (instance != null) {
      this.withClusterRoleSelectors(instance.getClusterRoleSelectors());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<LabelSelectorBuilder> clusterRoleSelectors = new ArrayList<LabelSelectorBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToClusterRoleSelectors(int index,LabelSelector item) {
    if (this.clusterRoleSelectors == null) {this.clusterRoleSelectors = new ArrayList<LabelSelectorBuilder>();}
    LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
    if (index < 0 || index >= clusterRoleSelectors.size()) { _visitables.get("clusterRoleSelectors").add(builder); clusterRoleSelectors.add(builder); } else { _visitables.get("clusterRoleSelectors").add(index, builder); clusterRoleSelectors.add(index, builder);}
    return (A)this;
  }
  public A setToClusterRoleSelectors(int index,LabelSelector item) {
    if (this.clusterRoleSelectors == null) {this.clusterRoleSelectors = new ArrayList<LabelSelectorBuilder>();}
    LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
    if (index < 0 || index >= clusterRoleSelectors.size()) { _visitables.get("clusterRoleSelectors").add(builder); clusterRoleSelectors.add(builder); } else { _visitables.get("clusterRoleSelectors").set(index, builder); clusterRoleSelectors.set(index, builder);}
    return (A)this;
  }
  public A addToClusterRoleSelectors(io.fabric8.kubernetes.api.model.LabelSelector... items) {
    if (this.clusterRoleSelectors == null) {this.clusterRoleSelectors = new ArrayList<LabelSelectorBuilder>();}
    for (LabelSelector item : items) {LabelSelectorBuilder builder = new LabelSelectorBuilder(item);_visitables.get("clusterRoleSelectors").add(builder);this.clusterRoleSelectors.add(builder);} return (A)this;
  }
  public A addAllToClusterRoleSelectors(Collection<LabelSelector> items) {
    if (this.clusterRoleSelectors == null) {this.clusterRoleSelectors = new ArrayList<LabelSelectorBuilder>();}
    for (LabelSelector item : items) {LabelSelectorBuilder builder = new LabelSelectorBuilder(item);_visitables.get("clusterRoleSelectors").add(builder);this.clusterRoleSelectors.add(builder);} return (A)this;
  }
  public A removeFromClusterRoleSelectors(io.fabric8.kubernetes.api.model.LabelSelector... items) {
    for (LabelSelector item : items) {LabelSelectorBuilder builder = new LabelSelectorBuilder(item);_visitables.get("clusterRoleSelectors").remove(builder);if (this.clusterRoleSelectors != null) {this.clusterRoleSelectors.remove(builder);}} return (A)this;
  }
  public A removeAllFromClusterRoleSelectors(Collection<LabelSelector> items) {
    for (LabelSelector item : items) {LabelSelectorBuilder builder = new LabelSelectorBuilder(item);_visitables.get("clusterRoleSelectors").remove(builder);if (this.clusterRoleSelectors != null) {this.clusterRoleSelectors.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromClusterRoleSelectors(Predicate<LabelSelectorBuilder> predicate) {
    if (clusterRoleSelectors == null) return (A) this;
    final Iterator<LabelSelectorBuilder> each = clusterRoleSelectors.iterator();
    final List visitables = _visitables.get("clusterRoleSelectors");
    while (each.hasNext()) {
      LabelSelectorBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildClusterRoleSelectors instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<LabelSelector> getClusterRoleSelectors() {
    return clusterRoleSelectors != null ? build(clusterRoleSelectors) : null;
  }
  public List<LabelSelector> buildClusterRoleSelectors() {
    return clusterRoleSelectors != null ? build(clusterRoleSelectors) : null;
  }
  public LabelSelector buildClusterRoleSelector(int index) {
    return this.clusterRoleSelectors.get(index).build();
  }
  public LabelSelector buildFirstClusterRoleSelector() {
    return this.clusterRoleSelectors.get(0).build();
  }
  public LabelSelector buildLastClusterRoleSelector() {
    return this.clusterRoleSelectors.get(clusterRoleSelectors.size() - 1).build();
  }
  public LabelSelector buildMatchingClusterRoleSelector(Predicate<LabelSelectorBuilder> predicate) {
    for (LabelSelectorBuilder item: clusterRoleSelectors) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingClusterRoleSelector(Predicate<LabelSelectorBuilder> predicate) {
    for (LabelSelectorBuilder item: clusterRoleSelectors) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withClusterRoleSelectors(List<LabelSelector> clusterRoleSelectors) {
    if (this.clusterRoleSelectors != null) { _visitables.get("clusterRoleSelectors").clear();}
    if (clusterRoleSelectors != null) {this.clusterRoleSelectors = new ArrayList(); for (LabelSelector item : clusterRoleSelectors){this.addToClusterRoleSelectors(item);}} else { this.clusterRoleSelectors = null;} return (A) this;
  }
  public A withClusterRoleSelectors(io.fabric8.kubernetes.api.model.LabelSelector... clusterRoleSelectors) {
    if (this.clusterRoleSelectors != null) {this.clusterRoleSelectors.clear(); _visitables.remove("clusterRoleSelectors"); }
    if (clusterRoleSelectors != null) {for (LabelSelector item :clusterRoleSelectors){ this.addToClusterRoleSelectors(item);}} return (A) this;
  }
  public Boolean hasClusterRoleSelectors() {
    return clusterRoleSelectors != null && !clusterRoleSelectors.isEmpty();
  }
  public AggregationRuleFluentImpl.ClusterRoleSelectorsNested<A> addNewClusterRoleSelector() {
    return new AggregationRuleFluentImpl.ClusterRoleSelectorsNestedImpl();
  }
  public AggregationRuleFluentImpl.ClusterRoleSelectorsNested<A> addNewClusterRoleSelectorLike(LabelSelector item) {
    return new AggregationRuleFluentImpl.ClusterRoleSelectorsNestedImpl(-1, item);
  }
  public AggregationRuleFluentImpl.ClusterRoleSelectorsNested<A> setNewClusterRoleSelectorLike(int index,LabelSelector item) {
    return new AggregationRuleFluentImpl.ClusterRoleSelectorsNestedImpl(index, item);
  }
  public AggregationRuleFluentImpl.ClusterRoleSelectorsNested<A> editClusterRoleSelector(int index) {
    if (clusterRoleSelectors.size() <= index) throw new RuntimeException("Can't edit clusterRoleSelectors. Index exceeds size.");
    return setNewClusterRoleSelectorLike(index, buildClusterRoleSelector(index));
  }
  public AggregationRuleFluentImpl.ClusterRoleSelectorsNested<A> editFirstClusterRoleSelector() {
    if (clusterRoleSelectors.size() == 0) throw new RuntimeException("Can't edit first clusterRoleSelectors. The list is empty.");
    return setNewClusterRoleSelectorLike(0, buildClusterRoleSelector(0));
  }
  public AggregationRuleFluentImpl.ClusterRoleSelectorsNested<A> editLastClusterRoleSelector() {
    int index = clusterRoleSelectors.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusterRoleSelectors. The list is empty.");
    return setNewClusterRoleSelectorLike(index, buildClusterRoleSelector(index));
  }
  public AggregationRuleFluentImpl.ClusterRoleSelectorsNested<A> editMatchingClusterRoleSelector(Predicate<LabelSelectorBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusterRoleSelectors.size();i++) { 
    if (predicate.test(clusterRoleSelectors.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusterRoleSelectors. No match found.");
    return setNewClusterRoleSelectorLike(index, buildClusterRoleSelector(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AggregationRuleFluentImpl that = (AggregationRuleFluentImpl) o;
    if (!java.util.Objects.equals(clusterRoleSelectors, that.clusterRoleSelectors)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clusterRoleSelectors,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterRoleSelectors != null) { sb.append("clusterRoleSelectors:"); sb.append(clusterRoleSelectors + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ClusterRoleSelectorsNestedImpl<N> extends LabelSelectorFluentImpl<AggregationRuleFluentImpl.ClusterRoleSelectorsNested<N>> implements AggregationRuleFluentImpl.ClusterRoleSelectorsNested<N>,Nested<N>{
    ClusterRoleSelectorsNestedImpl(int index,LabelSelector item) {
      this.index = index;
      this.builder = new LabelSelectorBuilder(this, item);
    }
    ClusterRoleSelectorsNestedImpl() {
      this.index = -1;
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    int index;
    public N and() {
      return (N) AggregationRuleFluentImpl.this.setToClusterRoleSelectors(index,builder.build());
    }
    public N endClusterRoleSelector() {
      return and();
    }
    
  }
  
}