package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RoleRefBuilder extends RoleRefFluentImpl<RoleRefBuilder> implements VisitableBuilder<RoleRef,RoleRefBuilder>{
  public RoleRefBuilder() {
    this(false);
  }
  public RoleRefBuilder(Boolean validationEnabled) {
    this(new RoleRef(), validationEnabled);
  }
  public RoleRefBuilder(RoleRefFluent<?> fluent) {
    this(fluent, false);
  }
  public RoleRefBuilder(RoleRefFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RoleRef(), validationEnabled);
  }
  public RoleRefBuilder(RoleRefFluent<?> fluent,RoleRef instance) {
    this(fluent, instance, false);
  }
  public RoleRefBuilder(RoleRefFluent<?> fluent,RoleRef instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiGroup(instance.getApiGroup()); 
    fluent.withKind(instance.getKind()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RoleRefBuilder(RoleRef instance) {
    this(instance,false);
  }
  public RoleRefBuilder(RoleRef instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiGroup(instance.getApiGroup()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  RoleRefFluent<?> fluent;
  Boolean validationEnabled;
  public RoleRef build() {
    RoleRef buildable = new RoleRef(fluent.getApiGroup(),fluent.getKind(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}