package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface RoleListFluent<A extends RoleListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(Integer index,Role item);
  public A setToItems(Integer index,Role item);
  public A addToItems(io.fabric8.kubernetes.api.model.rbac.Role... items);
  public A addAllToItems(Collection<Role> items);
  public A removeFromItems(io.fabric8.kubernetes.api.model.rbac.Role... items);
  public A removeAllFromItems(Collection<Role> items);
  public A removeMatchingFromItems(Predicate<RoleBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Role> getItems();
  public List<Role> buildItems();
  public Role buildItem(Integer index);
  public Role buildFirstItem();
  public Role buildLastItem();
  public Role buildMatchingItem(Predicate<RoleBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<RoleBuilder> predicate);
  public A withItems(List<Role> items);
  public A withItems(io.fabric8.kubernetes.api.model.rbac.Role... items);
  public Boolean hasItems();
  public RoleListFluent.ItemsNested<A> addNewItem();
  public RoleListFluent.ItemsNested<A> addNewItemLike(Role item);
  public RoleListFluent.ItemsNested<A> setNewItemLike(Integer index,Role item);
  public RoleListFluent.ItemsNested<A> editItem(Integer index);
  public RoleListFluent.ItemsNested<A> editFirstItem();
  public RoleListFluent.ItemsNested<A> editLastItem();
  public RoleListFluent.ItemsNested<A> editMatchingItem(Predicate<RoleBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public ListMeta getMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,RoleFluent<RoleListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  
}