package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubjectBuilder extends SubjectFluentImpl<SubjectBuilder> implements VisitableBuilder<Subject,io.fabric8.kubernetes.api.model.rbac.SubjectBuilder>{
  public SubjectBuilder() {
    this(false);
  }
  public SubjectBuilder(Boolean validationEnabled) {
    this(new Subject(), validationEnabled);
  }
  public SubjectBuilder(io.fabric8.kubernetes.api.model.rbac.SubjectFluent<?> fluent) {
    this(fluent, false);
  }
  public SubjectBuilder(io.fabric8.kubernetes.api.model.rbac.SubjectFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Subject(), validationEnabled);
  }
  public SubjectBuilder(io.fabric8.kubernetes.api.model.rbac.SubjectFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.Subject instance) {
    this(fluent, instance, false);
  }
  public SubjectBuilder(io.fabric8.kubernetes.api.model.rbac.SubjectFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.Subject instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiGroup(instance.getApiGroup()); 
    fluent.withKind(instance.getKind()); 
    fluent.withName(instance.getName()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SubjectBuilder(io.fabric8.kubernetes.api.model.rbac.Subject instance) {
    this(instance,false);
  }
  public SubjectBuilder(io.fabric8.kubernetes.api.model.rbac.Subject instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiGroup(instance.getApiGroup()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.rbac.SubjectFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.rbac.Subject build() {
    Subject buildable = new Subject(fluent.getApiGroup(),fluent.getKind(),fluent.getName(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}