package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RoleRefBuilder extends RoleRefFluentImpl<RoleRefBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.rbac.RoleRef,io.fabric8.kubernetes.api.model.rbac.RoleRefBuilder>{
  public RoleRefBuilder() {
    this(false);
  }
  public RoleRefBuilder(Boolean validationEnabled) {
    this(new RoleRef(), validationEnabled);
  }
  public RoleRefBuilder(RoleRefFluent<?> fluent) {
    this(fluent, false);
  }
  public RoleRefBuilder(io.fabric8.kubernetes.api.model.rbac.RoleRefFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new RoleRef(), validationEnabled);
  }
  public RoleRefBuilder(io.fabric8.kubernetes.api.model.rbac.RoleRefFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.RoleRef instance) {
    this(fluent, instance, false);
  }
  public RoleRefBuilder(io.fabric8.kubernetes.api.model.rbac.RoleRefFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.RoleRef instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiGroup(instance.getApiGroup()); 
    fluent.withKind(instance.getKind()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RoleRefBuilder(io.fabric8.kubernetes.api.model.rbac.RoleRef instance) {
    this(instance,false);
  }
  public RoleRefBuilder(io.fabric8.kubernetes.api.model.rbac.RoleRef instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiGroup(instance.getApiGroup()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.rbac.RoleRefFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.rbac.RoleRef build() {
    RoleRef buildable = new RoleRef(fluent.getApiGroup(),fluent.getKind(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}