package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RoleListBuilder extends RoleListFluentImpl<RoleListBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.rbac.RoleList,io.fabric8.kubernetes.api.model.rbac.RoleListBuilder>{
  public RoleListBuilder() {
    this(false);
  }
  public RoleListBuilder(Boolean validationEnabled) {
    this(new RoleList(), validationEnabled);
  }
  public RoleListBuilder(RoleListFluent<?> fluent) {
    this(fluent, false);
  }
  public RoleListBuilder(io.fabric8.kubernetes.api.model.rbac.RoleListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new RoleList(), validationEnabled);
  }
  public RoleListBuilder(io.fabric8.kubernetes.api.model.rbac.RoleListFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.RoleList instance) {
    this(fluent, instance, false);
  }
  public RoleListBuilder(io.fabric8.kubernetes.api.model.rbac.RoleListFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.RoleList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RoleListBuilder(io.fabric8.kubernetes.api.model.rbac.RoleList instance) {
    this(instance,false);
  }
  public RoleListBuilder(io.fabric8.kubernetes.api.model.rbac.RoleList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.rbac.RoleListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.rbac.RoleList build() {
    RoleList buildable = new RoleList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}