package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RoleBuilder extends RoleFluentImpl<RoleBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.rbac.Role,io.fabric8.kubernetes.api.model.rbac.RoleBuilder>{
  public RoleBuilder() {
    this(false);
  }
  public RoleBuilder(Boolean validationEnabled) {
    this(new Role(), validationEnabled);
  }
  public RoleBuilder(RoleFluent<?> fluent) {
    this(fluent, false);
  }
  public RoleBuilder(io.fabric8.kubernetes.api.model.rbac.RoleFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Role(), validationEnabled);
  }
  public RoleBuilder(io.fabric8.kubernetes.api.model.rbac.RoleFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.Role instance) {
    this(fluent, instance, false);
  }
  public RoleBuilder(io.fabric8.kubernetes.api.model.rbac.RoleFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.Role instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withRules(instance.getRules()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RoleBuilder(io.fabric8.kubernetes.api.model.rbac.Role instance) {
    this(instance,false);
  }
  public RoleBuilder(io.fabric8.kubernetes.api.model.rbac.Role instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withRules(instance.getRules()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.rbac.RoleFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.rbac.Role build() {
    Role buildable = new Role(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getRules());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}