package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RoleBindingListBuilder extends RoleBindingListFluentImpl<RoleBindingListBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.rbac.RoleBindingList,RoleBindingListBuilder>{
  public RoleBindingListBuilder() {
    this(false);
  }
  public RoleBindingListBuilder(Boolean validationEnabled) {
    this(new RoleBindingList(), validationEnabled);
  }
  public RoleBindingListBuilder(RoleBindingListFluent<?> fluent) {
    this(fluent, false);
  }
  public RoleBindingListBuilder(io.fabric8.kubernetes.api.model.rbac.RoleBindingListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new RoleBindingList(), validationEnabled);
  }
  public RoleBindingListBuilder(io.fabric8.kubernetes.api.model.rbac.RoleBindingListFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.RoleBindingList instance) {
    this(fluent, instance, false);
  }
  public RoleBindingListBuilder(io.fabric8.kubernetes.api.model.rbac.RoleBindingListFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.RoleBindingList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RoleBindingListBuilder(io.fabric8.kubernetes.api.model.rbac.RoleBindingList instance) {
    this(instance,false);
  }
  public RoleBindingListBuilder(io.fabric8.kubernetes.api.model.rbac.RoleBindingList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.rbac.RoleBindingListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.rbac.RoleBindingList build() {
    RoleBindingList buildable = new RoleBindingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}