package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RoleBindingBuilder extends RoleBindingFluentImpl<RoleBindingBuilder> implements VisitableBuilder<RoleBinding,io.fabric8.kubernetes.api.model.rbac.RoleBindingBuilder>{
  public RoleBindingBuilder() {
    this(false);
  }
  public RoleBindingBuilder(Boolean validationEnabled) {
    this(new RoleBinding(), validationEnabled);
  }
  public RoleBindingBuilder(io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent<?> fluent) {
    this(fluent, false);
  }
  public RoleBindingBuilder(io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new RoleBinding(), validationEnabled);
  }
  public RoleBindingBuilder(io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.RoleBinding instance) {
    this(fluent, instance, false);
  }
  public RoleBindingBuilder(io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.RoleBinding instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withRoleRef(instance.getRoleRef()); 
    fluent.withSubjects(instance.getSubjects()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RoleBindingBuilder(io.fabric8.kubernetes.api.model.rbac.RoleBinding instance) {
    this(instance,false);
  }
  public RoleBindingBuilder(io.fabric8.kubernetes.api.model.rbac.RoleBinding instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withRoleRef(instance.getRoleRef()); 
    this.withSubjects(instance.getSubjects()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.rbac.RoleBinding build() {
    RoleBinding buildable = new RoleBinding(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getRoleRef(),fluent.getSubjects());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}