package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PolicyRuleBuilder extends PolicyRuleFluentImpl<PolicyRuleBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.rbac.PolicyRule,io.fabric8.kubernetes.api.model.rbac.PolicyRuleBuilder>{
  public PolicyRuleBuilder() {
    this(false);
  }
  public PolicyRuleBuilder(Boolean validationEnabled) {
    this(new PolicyRule(), validationEnabled);
  }
  public PolicyRuleBuilder(PolicyRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public PolicyRuleBuilder(io.fabric8.kubernetes.api.model.rbac.PolicyRuleFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PolicyRule(), validationEnabled);
  }
  public PolicyRuleBuilder(io.fabric8.kubernetes.api.model.rbac.PolicyRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.PolicyRule instance) {
    this(fluent, instance, false);
  }
  public PolicyRuleBuilder(io.fabric8.kubernetes.api.model.rbac.PolicyRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.PolicyRule instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiGroups(instance.getApiGroups()); 
    fluent.withNonResourceURLs(instance.getNonResourceURLs()); 
    fluent.withResourceNames(instance.getResourceNames()); 
    fluent.withResources(instance.getResources()); 
    fluent.withVerbs(instance.getVerbs()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PolicyRuleBuilder(io.fabric8.kubernetes.api.model.rbac.PolicyRule instance) {
    this(instance,false);
  }
  public PolicyRuleBuilder(io.fabric8.kubernetes.api.model.rbac.PolicyRule instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiGroups(instance.getApiGroups()); 
    this.withNonResourceURLs(instance.getNonResourceURLs()); 
    this.withResourceNames(instance.getResourceNames()); 
    this.withResources(instance.getResources()); 
    this.withVerbs(instance.getVerbs()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.rbac.PolicyRuleFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.rbac.PolicyRule build() {
    PolicyRule buildable = new PolicyRule(fluent.getApiGroups(),fluent.getNonResourceURLs(),fluent.getResourceNames(),fluent.getResources(),fluent.getVerbs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}