package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterRoleListBuilder extends ClusterRoleListFluentImpl<ClusterRoleListBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.rbac.ClusterRoleList,ClusterRoleListBuilder>{
  public ClusterRoleListBuilder() {
    this(false);
  }
  public ClusterRoleListBuilder(Boolean validationEnabled) {
    this(new ClusterRoleList(), validationEnabled);
  }
  public ClusterRoleListBuilder(ClusterRoleListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterRoleListBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterRoleList(), validationEnabled);
  }
  public ClusterRoleListBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleListFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.ClusterRoleList instance) {
    this(fluent, instance, false);
  }
  public ClusterRoleListBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleListFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.ClusterRoleList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterRoleListBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleList instance) {
    this(instance,false);
  }
  public ClusterRoleListBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.rbac.ClusterRoleListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.rbac.ClusterRoleList build() {
    ClusterRoleList buildable = new ClusterRoleList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}