package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterRoleBindingListBuilder extends ClusterRoleBindingListFluentImpl<ClusterRoleBindingListBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingList,io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingListBuilder>{
  public ClusterRoleBindingListBuilder() {
    this(false);
  }
  public ClusterRoleBindingListBuilder(Boolean validationEnabled) {
    this(new ClusterRoleBindingList(), validationEnabled);
  }
  public ClusterRoleBindingListBuilder(ClusterRoleBindingListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterRoleBindingListBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterRoleBindingList(), validationEnabled);
  }
  public ClusterRoleBindingListBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingListFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingList instance) {
    this(fluent, instance, false);
  }
  public ClusterRoleBindingListBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingListFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterRoleBindingListBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingList instance) {
    this(instance,false);
  }
  public ClusterRoleBindingListBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingList build() {
    ClusterRoleBindingList buildable = new ClusterRoleBindingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}