package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterRoleBindingBuilder extends ClusterRoleBindingFluentImpl<ClusterRoleBindingBuilder> implements VisitableBuilder<ClusterRoleBinding,io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingBuilder>{
  public ClusterRoleBindingBuilder() {
    this(false);
  }
  public ClusterRoleBindingBuilder(Boolean validationEnabled) {
    this(new ClusterRoleBinding(), validationEnabled);
  }
  public ClusterRoleBindingBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterRoleBindingBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterRoleBinding(), validationEnabled);
  }
  public ClusterRoleBindingBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding instance) {
    this(fluent, instance, false);
  }
  public ClusterRoleBindingBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withRoleRef(instance.getRoleRef()); 
    fluent.withSubjects(instance.getSubjects()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterRoleBindingBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding instance) {
    this(instance,false);
  }
  public ClusterRoleBindingBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withRoleRef(instance.getRoleRef()); 
    this.withSubjects(instance.getSubjects()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding build() {
    ClusterRoleBinding buildable = new ClusterRoleBinding(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getRoleRef(),fluent.getSubjects());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}