package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AggregationRuleBuilder extends AggregationRuleFluentImpl<AggregationRuleBuilder> implements VisitableBuilder<AggregationRule,io.fabric8.kubernetes.api.model.rbac.AggregationRuleBuilder>{
  public AggregationRuleBuilder() {
    this(false);
  }
  public AggregationRuleBuilder(Boolean validationEnabled) {
    this(new AggregationRule(), validationEnabled);
  }
  public AggregationRuleBuilder(AggregationRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public AggregationRuleBuilder(io.fabric8.kubernetes.api.model.rbac.AggregationRuleFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new AggregationRule(), validationEnabled);
  }
  public AggregationRuleBuilder(io.fabric8.kubernetes.api.model.rbac.AggregationRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.AggregationRule instance) {
    this(fluent, instance, false);
  }
  public AggregationRuleBuilder(io.fabric8.kubernetes.api.model.rbac.AggregationRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.AggregationRule instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClusterRoleSelectors(instance.getClusterRoleSelectors()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AggregationRuleBuilder(io.fabric8.kubernetes.api.model.rbac.AggregationRule instance) {
    this(instance,false);
  }
  public AggregationRuleBuilder(io.fabric8.kubernetes.api.model.rbac.AggregationRule instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withClusterRoleSelectors(instance.getClusterRoleSelectors()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.rbac.AggregationRuleFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.rbac.AggregationRule build() {
    AggregationRule buildable = new AggregationRule(fluent.getClusterRoleSelectors());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}