package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class RoleBuilder extends io.fabric8.kubernetes.api.model.rbac.RoleFluentImpl<io.fabric8.kubernetes.api.model.rbac.RoleBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.rbac.Role,io.fabric8.kubernetes.api.model.rbac.RoleBuilder>{
  public RoleBuilder() {
    this(false);
  }
  public RoleBuilder(java.lang.Boolean validationEnabled) {
    this(new Role(), validationEnabled);
  }
  public RoleBuilder(io.fabric8.kubernetes.api.model.rbac.RoleFluent<?> fluent) {
    this(fluent, false);
  }
  public RoleBuilder(io.fabric8.kubernetes.api.model.rbac.RoleFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Role(), validationEnabled);
  }
  public RoleBuilder(io.fabric8.kubernetes.api.model.rbac.RoleFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.Role instance) {
    this(fluent, instance, false);
  }
  public RoleBuilder(io.fabric8.kubernetes.api.model.rbac.RoleFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.Role instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withRules(instance.getRules()); 
    this.validationEnabled = validationEnabled; 
  }
  public RoleBuilder(io.fabric8.kubernetes.api.model.rbac.Role instance) {
    this(instance,false);
  }
  public RoleBuilder(io.fabric8.kubernetes.api.model.rbac.Role instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withRules(instance.getRules()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.rbac.RoleFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.rbac.Role build() {
    Role buildable = new Role(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getRules());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RoleBuilder that = (RoleBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}