package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
public class RoleBindingFluentImpl<A extends io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent<A>{
  public RoleBindingFluentImpl() {
  }
  public RoleBindingFluentImpl(io.fabric8.kubernetes.api.model.rbac.RoleBinding instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withRoleRef(instance.getRoleRef()); 
    this.withSubjects(instance.getSubjects()); 
  }
  private java.lang.String apiVersion;
  private java.lang.String kind;
  private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
  private io.fabric8.kubernetes.api.model.rbac.RoleRefBuilder roleRef;
  private java.util.List<io.fabric8.kubernetes.api.model.rbac.SubjectBuilder> subjects =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.rbac.SubjectBuilder>();
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public java.lang.Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * Method is deprecated. use withApiVersion instead.
   */
  @java.lang.Deprecated
  public A withNewApiVersion(java.lang.String arg0) {
    return (A)withApiVersion(new String(arg0));
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * Method is deprecated. use withKind instead.
   */
  @java.lang.Deprecated
  public A withNewKind(java.lang.String arg0) {
    return (A)withKind(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent.MetadataNested<A> withNewMetadata() {
    return new io.fabric8.kubernetes.api.model.rbac.RoleBindingFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return new io.fabric8.kubernetes.api.model.rbac.RoleBindingFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRoleRef instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.rbac.RoleRef getRoleRef() {
    return this.roleRef!=null?this.roleRef.build():null;
  }
  public io.fabric8.kubernetes.api.model.rbac.RoleRef buildRoleRef() {
    return this.roleRef!=null?this.roleRef.build():null;
  }
  public A withRoleRef(io.fabric8.kubernetes.api.model.rbac.RoleRef roleRef) {
    _visitables.get("roleRef").remove(this.roleRef);
    if (roleRef!=null){ this.roleRef= new io.fabric8.kubernetes.api.model.rbac.RoleRefBuilder(roleRef); _visitables.get("roleRef").add(this.roleRef);} return (A) this;
  }
  public java.lang.Boolean hasRoleRef() {
    return this.roleRef != null;
  }
  public A withNewRoleRef(java.lang.String apiGroup,java.lang.String kind,java.lang.String name) {
    return (A)withRoleRef(new RoleRef(apiGroup, kind, name));
  }
  public io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent.RoleRefNested<A> withNewRoleRef() {
    return new io.fabric8.kubernetes.api.model.rbac.RoleBindingFluentImpl.RoleRefNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent.RoleRefNested<A> withNewRoleRefLike(io.fabric8.kubernetes.api.model.rbac.RoleRef item) {
    return new io.fabric8.kubernetes.api.model.rbac.RoleBindingFluentImpl.RoleRefNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent.RoleRefNested<A> editRoleRef() {
    return withNewRoleRefLike(getRoleRef());
  }
  public io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent.RoleRefNested<A> editOrNewRoleRef() {
    return withNewRoleRefLike(getRoleRef() != null ? getRoleRef(): new io.fabric8.kubernetes.api.model.rbac.RoleRefBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent.RoleRefNested<A> editOrNewRoleRefLike(io.fabric8.kubernetes.api.model.rbac.RoleRef item) {
    return withNewRoleRefLike(getRoleRef() != null ? getRoleRef(): item);
  }
  public A addToSubjects(java.lang.Integer index,io.fabric8.kubernetes.api.model.rbac.Subject item) {
    if (this.subjects == null) {this.subjects = new java.util.ArrayList<io.fabric8.kubernetes.api.model.rbac.SubjectBuilder>();}
    io.fabric8.kubernetes.api.model.rbac.SubjectBuilder builder = new io.fabric8.kubernetes.api.model.rbac.SubjectBuilder(item);_visitables.get("subjects").add(index >= 0 ? index : _visitables.get("subjects").size(), builder);this.subjects.add(index >= 0 ? index : subjects.size(), builder); return (A)this;
  }
  public A setToSubjects(java.lang.Integer index,io.fabric8.kubernetes.api.model.rbac.Subject item) {
    if (this.subjects == null) {this.subjects = new java.util.ArrayList<io.fabric8.kubernetes.api.model.rbac.SubjectBuilder>();}
    io.fabric8.kubernetes.api.model.rbac.SubjectBuilder builder = new io.fabric8.kubernetes.api.model.rbac.SubjectBuilder(item);
    if (index < 0 || index >= _visitables.get("subjects").size()) { _visitables.get("subjects").add(builder); } else { _visitables.get("subjects").set(index, builder);}
    if (index < 0 || index >= subjects.size()) { subjects.add(builder); } else { subjects.set(index, builder);}
     return (A)this;
  }
  public A addToSubjects(io.fabric8.kubernetes.api.model.rbac.Subject... items) {
    if (this.subjects == null) {this.subjects = new java.util.ArrayList<io.fabric8.kubernetes.api.model.rbac.SubjectBuilder>();}
    for (io.fabric8.kubernetes.api.model.rbac.Subject item : items) {io.fabric8.kubernetes.api.model.rbac.SubjectBuilder builder = new io.fabric8.kubernetes.api.model.rbac.SubjectBuilder(item);_visitables.get("subjects").add(builder);this.subjects.add(builder);} return (A)this;
  }
  public A addAllToSubjects(java.util.Collection<io.fabric8.kubernetes.api.model.rbac.Subject> items) {
    if (this.subjects == null) {this.subjects = new java.util.ArrayList<io.fabric8.kubernetes.api.model.rbac.SubjectBuilder>();}
    for (io.fabric8.kubernetes.api.model.rbac.Subject item : items) {io.fabric8.kubernetes.api.model.rbac.SubjectBuilder builder = new io.fabric8.kubernetes.api.model.rbac.SubjectBuilder(item);_visitables.get("subjects").add(builder);this.subjects.add(builder);} return (A)this;
  }
  public A removeFromSubjects(io.fabric8.kubernetes.api.model.rbac.Subject... items) {
    for (io.fabric8.kubernetes.api.model.rbac.Subject item : items) {io.fabric8.kubernetes.api.model.rbac.SubjectBuilder builder = new io.fabric8.kubernetes.api.model.rbac.SubjectBuilder(item);_visitables.get("subjects").remove(builder);if (this.subjects != null) {this.subjects.remove(builder);}} return (A)this;
  }
  public A removeAllFromSubjects(java.util.Collection<io.fabric8.kubernetes.api.model.rbac.Subject> items) {
    for (io.fabric8.kubernetes.api.model.rbac.Subject item : items) {io.fabric8.kubernetes.api.model.rbac.SubjectBuilder builder = new io.fabric8.kubernetes.api.model.rbac.SubjectBuilder(item);_visitables.get("subjects").remove(builder);if (this.subjects != null) {this.subjects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSubjects(java.util.function.Predicate<io.fabric8.kubernetes.api.model.rbac.SubjectBuilder> predicate) {
    if (subjects == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.rbac.SubjectBuilder> each = subjects.iterator();
    final List visitables = _visitables.get("subjects");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.rbac.SubjectBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSubjects instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.rbac.Subject> getSubjects() {
    return build(subjects);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.rbac.Subject> buildSubjects() {
    return build(subjects);
  }
  public io.fabric8.kubernetes.api.model.rbac.Subject buildSubject(java.lang.Integer index) {
    return this.subjects.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.rbac.Subject buildFirstSubject() {
    return this.subjects.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.rbac.Subject buildLastSubject() {
    return this.subjects.get(subjects.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.rbac.Subject buildMatchingSubject(java.util.function.Predicate<io.fabric8.kubernetes.api.model.rbac.SubjectBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.rbac.SubjectBuilder item: subjects) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingSubject(java.util.function.Predicate<io.fabric8.kubernetes.api.model.rbac.SubjectBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.rbac.SubjectBuilder item: subjects) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSubjects(java.util.List<io.fabric8.kubernetes.api.model.rbac.Subject> subjects) {
    if (this.subjects != null) { _visitables.get("subjects").removeAll(this.subjects);}
    if (subjects != null) {this.subjects = new java.util.ArrayList<io.fabric8.kubernetes.api.model.rbac.SubjectBuilder>(); for (io.fabric8.kubernetes.api.model.rbac.Subject item : subjects){this.addToSubjects(item);}} else { this.subjects = null;} return (A) this;
  }
  public A withSubjects(io.fabric8.kubernetes.api.model.rbac.Subject... subjects) {
    if (this.subjects != null) {this.subjects.clear();}
    if (subjects != null) {for (io.fabric8.kubernetes.api.model.rbac.Subject item :subjects){ this.addToSubjects(item);}} return (A) this;
  }
  public java.lang.Boolean hasSubjects() {
    return subjects != null && !subjects.isEmpty();
  }
  public A addNewSubject(java.lang.String apiGroup,java.lang.String kind,java.lang.String name,java.lang.String namespace) {
    return (A)addToSubjects(new Subject(apiGroup, kind, name, namespace));
  }
  public io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent.SubjectsNested<A> addNewSubject() {
    return new io.fabric8.kubernetes.api.model.rbac.RoleBindingFluentImpl.SubjectsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent.SubjectsNested<A> addNewSubjectLike(io.fabric8.kubernetes.api.model.rbac.Subject item) {
    return new io.fabric8.kubernetes.api.model.rbac.RoleBindingFluentImpl.SubjectsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent.SubjectsNested<A> setNewSubjectLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.rbac.Subject item) {
    return new io.fabric8.kubernetes.api.model.rbac.RoleBindingFluentImpl.SubjectsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent.SubjectsNested<A> editSubject(java.lang.Integer index) {
    if (subjects.size() <= index) throw new RuntimeException("Can't edit subjects. Index exceeds size.");
    return setNewSubjectLike(index, buildSubject(index));
  }
  public io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent.SubjectsNested<A> editFirstSubject() {
    if (subjects.size() == 0) throw new RuntimeException("Can't edit first subjects. The list is empty.");
    return setNewSubjectLike(0, buildSubject(0));
  }
  public io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent.SubjectsNested<A> editLastSubject() {
    int index = subjects.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last subjects. The list is empty.");
    return setNewSubjectLike(index, buildSubject(index));
  }
  public io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent.SubjectsNested<A> editMatchingSubject(java.util.function.Predicate<io.fabric8.kubernetes.api.model.rbac.SubjectBuilder> predicate) {
    int index = -1;
    for (int i=0;i<subjects.size();i++) { 
    if (predicate.test(subjects.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching subjects. No match found.");
    return setNewSubjectLike(index, buildSubject(index));
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RoleBindingFluentImpl that = (RoleBindingFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (roleRef != null ? !roleRef.equals(that.roleRef) :that.roleRef != null) return false;
    if (subjects != null ? !subjects.equals(that.subjects) :that.subjects != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  roleRef,  subjects,  super.hashCode());
  }
  public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent.MetadataNested<N>> implements io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;
    public N and() {
      return (N) RoleBindingFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  public class RoleRefNestedImpl<N> extends io.fabric8.kubernetes.api.model.rbac.RoleRefFluentImpl<io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent.RoleRefNested<N>> implements io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent.RoleRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RoleRefNestedImpl(io.fabric8.kubernetes.api.model.rbac.RoleRef item) {
      this.builder = new io.fabric8.kubernetes.api.model.rbac.RoleRefBuilder(this, item);
    }
    RoleRefNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.rbac.RoleRefBuilder(this);
    }
    io.fabric8.kubernetes.api.model.rbac.RoleRefBuilder builder;
    public N and() {
      return (N) RoleBindingFluentImpl.this.withRoleRef(builder.build());
    }
    public N endRoleRef() {
      return and();
    }
    
  }
  public class SubjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.rbac.SubjectFluentImpl<io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent.SubjectsNested<N>> implements io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent.SubjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SubjectsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.rbac.Subject item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.rbac.SubjectBuilder(this, item);
    }
    SubjectsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.rbac.SubjectBuilder(this);
    }
    io.fabric8.kubernetes.api.model.rbac.SubjectBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) RoleBindingFluentImpl.this.setToSubjects(index,builder.build());
    }
    public N endSubject() {
      return and();
    }
    
  }
  
}