package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ClusterRoleBindingBuilder extends io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingFluentImpl<io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding,io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingBuilder>{
  public ClusterRoleBindingBuilder() {
    this(false);
  }
  public ClusterRoleBindingBuilder(java.lang.Boolean validationEnabled) {
    this(new ClusterRoleBinding(), validationEnabled);
  }
  public ClusterRoleBindingBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterRoleBindingBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterRoleBinding(), validationEnabled);
  }
  public ClusterRoleBindingBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding instance) {
    this(fluent, instance, false);
  }
  public ClusterRoleBindingBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withRoleRef(instance.getRoleRef()); 
    fluent.withSubjects(instance.getSubjects()); 
    this.validationEnabled = validationEnabled; 
  }
  public ClusterRoleBindingBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding instance) {
    this(instance,false);
  }
  public ClusterRoleBindingBuilder(io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withRoleRef(instance.getRoleRef()); 
    this.withSubjects(instance.getSubjects()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding build() {
    ClusterRoleBinding buildable = new ClusterRoleBinding(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getRoleRef(),fluent.getSubjects());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterRoleBindingBuilder that = (ClusterRoleBindingBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}