package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class AggregationRuleBuilder extends io.fabric8.kubernetes.api.model.rbac.AggregationRuleFluentImpl<io.fabric8.kubernetes.api.model.rbac.AggregationRuleBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.rbac.AggregationRule,io.fabric8.kubernetes.api.model.rbac.AggregationRuleBuilder>{
  public AggregationRuleBuilder() {
    this(false);
  }
  public AggregationRuleBuilder(java.lang.Boolean validationEnabled) {
    this(new AggregationRule(), validationEnabled);
  }
  public AggregationRuleBuilder(io.fabric8.kubernetes.api.model.rbac.AggregationRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public AggregationRuleBuilder(io.fabric8.kubernetes.api.model.rbac.AggregationRuleFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new AggregationRule(), validationEnabled);
  }
  public AggregationRuleBuilder(io.fabric8.kubernetes.api.model.rbac.AggregationRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.AggregationRule instance) {
    this(fluent, instance, false);
  }
  public AggregationRuleBuilder(io.fabric8.kubernetes.api.model.rbac.AggregationRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.AggregationRule instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClusterRoleSelectors(instance.getClusterRoleSelectors()); 
    this.validationEnabled = validationEnabled; 
  }
  public AggregationRuleBuilder(io.fabric8.kubernetes.api.model.rbac.AggregationRule instance) {
    this(instance,false);
  }
  public AggregationRuleBuilder(io.fabric8.kubernetes.api.model.rbac.AggregationRule instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withClusterRoleSelectors(instance.getClusterRoleSelectors()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.rbac.AggregationRuleFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.rbac.AggregationRule build() {
    AggregationRule buildable = new AggregationRule(fluent.getClusterRoleSelectors());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AggregationRuleBuilder that = (AggregationRuleBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}