package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RoleBindingListBuilder extends io.fabric8.kubernetes.api.model.rbac.RoleBindingListFluentImpl<io.fabric8.kubernetes.api.model.rbac.RoleBindingListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.rbac.RoleBindingList,io.fabric8.kubernetes.api.model.rbac.RoleBindingListBuilder> {

    io.fabric8.kubernetes.api.model.rbac.RoleBindingListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public RoleBindingListBuilder() {
        this(true);
    }

    public RoleBindingListBuilder(java.lang.Boolean validationEnabled) {
        this(new RoleBindingList(), validationEnabled);
    }

    public RoleBindingListBuilder(io.fabric8.kubernetes.api.model.rbac.RoleBindingListFluent<?> fluent) {
        this(fluent, true);
    }

    public RoleBindingListBuilder(io.fabric8.kubernetes.api.model.rbac.RoleBindingListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new RoleBindingList(), validationEnabled);
    }

    public RoleBindingListBuilder(io.fabric8.kubernetes.api.model.rbac.RoleBindingListFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.RoleBindingList instance) {
        this(fluent, instance, true);
    }

    public RoleBindingListBuilder(io.fabric8.kubernetes.api.model.rbac.RoleBindingListFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.RoleBindingList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public RoleBindingListBuilder(io.fabric8.kubernetes.api.model.rbac.RoleBindingList instance) {
        this(instance,true);
    }

    public RoleBindingListBuilder(io.fabric8.kubernetes.api.model.rbac.RoleBindingList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.rbac.RoleBindingList build() {
        RoleBindingList buildable = new RoleBindingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RoleBindingListBuilder that = (RoleBindingListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
