package io.fabric8.kubernetes.api.model.rbac;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class SubjectFluentImpl<A extends SubjectFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SubjectFluent<A> {

    private String apiGroup;
    private String kind;
    private String name;
    private String namespace;

    public SubjectFluentImpl() {
    }

    public SubjectFluentImpl(Subject instance) {
        this.withApiGroup(instance.getApiGroup()); 
        this.withKind(instance.getKind()); 
        this.withName(instance.getName()); 
        this.withNamespace(instance.getNamespace()); 
    }

    public String getApiGroup() {
        return this.apiGroup;
    }

    public A withApiGroup(String apiGroup) {
        this.apiGroup=apiGroup; return (A) this;
    }

    public Boolean hasApiGroup() {
        return this.apiGroup != null;
    }

    public A withNewApiGroup(StringBuilder arg1) {
        return (A)withApiGroup(new String(arg1));
    }

    public A withNewApiGroup(int[] arg1,int arg2,int arg3) {
        return (A)withApiGroup(new String(arg1, arg2, arg3));
    }

    public A withNewApiGroup(char[] arg1) {
        return (A)withApiGroup(new String(arg1));
    }

    public A withNewApiGroup(StringBuffer arg1) {
        return (A)withApiGroup(new String(arg1));
    }

    public A withNewApiGroup(byte[] arg1,int arg2) {
        return (A)withApiGroup(new String(arg1, arg2));
    }

    public A withNewApiGroup(byte[] arg1) {
        return (A)withApiGroup(new String(arg1));
    }

    public A withNewApiGroup(char[] arg1,int arg2,int arg3) {
        return (A)withApiGroup(new String(arg1, arg2, arg3));
    }

    public A withNewApiGroup(byte[] arg1,int arg2,int arg3) {
        return (A)withApiGroup(new String(arg1, arg2, arg3));
    }

    public A withNewApiGroup(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withApiGroup(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewApiGroup(String arg1) {
        return (A)withApiGroup(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(int[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(char[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(byte[] arg1,int arg2) {
        return (A)withKind(new String(arg1, arg2));
    }

    public A withNewKind(byte[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(char[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withKind(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(int[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(char[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(byte[] arg1,int arg2) {
        return (A)withName(new String(arg1, arg2));
    }

    public A withNewName(byte[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(char[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace=namespace; return (A) this;
    }

    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    public A withNewNamespace(StringBuilder arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(int[] arg1,int arg2,int arg3) {
        return (A)withNamespace(new String(arg1, arg2, arg3));
    }

    public A withNewNamespace(char[] arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuffer arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(byte[] arg1,int arg2) {
        return (A)withNamespace(new String(arg1, arg2));
    }

    public A withNewNamespace(byte[] arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(char[] arg1,int arg2,int arg3) {
        return (A)withNamespace(new String(arg1, arg2, arg3));
    }

    public A withNewNamespace(byte[] arg1,int arg2,int arg3) {
        return (A)withNamespace(new String(arg1, arg2, arg3));
    }

    public A withNewNamespace(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withNamespace(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewNamespace(String arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SubjectFluentImpl that = (SubjectFluentImpl) o;
        if (apiGroup != null ? !apiGroup.equals(that.apiGroup) :that.apiGroup != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiGroup,  kind,  name,  namespace,  super.hashCode());
    }

}
