package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ClusterRoleBindingListFluent<A extends ClusterRoleBindingListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,ClusterRoleBinding item);
    public A setToItems(int index,ClusterRoleBinding item);
    public A addToItems(ClusterRoleBinding... items);
    public A addAllToItems(Collection<ClusterRoleBinding> items);
    public A removeFromItems(ClusterRoleBinding... items);
    public A removeAllFromItems(Collection<ClusterRoleBinding> items);
    public A removeMatchingFromItems(Predicate<ClusterRoleBindingBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<ClusterRoleBinding> getItems();
    public List<ClusterRoleBinding> buildItems();
    public ClusterRoleBinding buildItem(int index);
    public ClusterRoleBinding buildFirstItem();
    public ClusterRoleBinding buildLastItem();
    public ClusterRoleBinding buildMatchingItem(Predicate<ClusterRoleBindingBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<ClusterRoleBindingBuilder> predicate);
    public A withItems(List<ClusterRoleBinding> items);
    public A withItems(ClusterRoleBinding... items);
    public Boolean hasItems();
    public ClusterRoleBindingListFluent.ItemsNested<A> addNewItem();
    public ClusterRoleBindingListFluent.ItemsNested<A> addNewItemLike(ClusterRoleBinding item);
    public ClusterRoleBindingListFluent.ItemsNested<A> setNewItemLike(int index,ClusterRoleBinding item);
    public ClusterRoleBindingListFluent.ItemsNested<A> editItem(int index);
    public ClusterRoleBindingListFluent.ItemsNested<A> editFirstItem();
    public ClusterRoleBindingListFluent.ItemsNested<A> editLastItem();
    public ClusterRoleBindingListFluent.ItemsNested<A> editMatchingItem(Predicate<ClusterRoleBindingBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterRoleBindingFluent<ClusterRoleBindingListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
