package io.fabric8.kubernetes.api.model.rbac;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class RoleRefFluentImpl<A extends RoleRefFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RoleRefFluent<A> {

    private String apiGroup;
    private String kind;
    private String name;

    public RoleRefFluentImpl() { 
    }


    public RoleRefFluentImpl(RoleRef instance) { 
        this.withApiGroup(instance.getApiGroup()); 
        this.withKind(instance.getKind()); 
        this.withName(instance.getName()); 
    }


    public String getApiGroup() {
        return this.apiGroup;
    }

    public A withApiGroup(String apiGroup) {
        this.apiGroup=apiGroup; return (A) this;
    }

    public Boolean hasApiGroup() {
        return this.apiGroup != null;
    }

    public A withNewApiGroup(String arg1) {
        return (A)withApiGroup(new String(arg1));
    }

    public A withNewApiGroup(StringBuilder arg1) {
        return (A)withApiGroup(new String(arg1));
    }

    public A withNewApiGroup(StringBuffer arg1) {
        return (A)withApiGroup(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RoleRefFluentImpl that = (RoleRefFluentImpl) o;
        if (apiGroup != null ? !apiGroup.equals(that.apiGroup) :that.apiGroup != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiGroup,  kind,  name,  super.hashCode());
    }

}
