
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.rbac.AggregationRule;
import io.fabric8.kubernetes.api.model.rbac.ClusterRole;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingList;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleList;
import io.fabric8.kubernetes.api.model.rbac.Role;
import io.fabric8.kubernetes.api.model.rbac.RoleBinding;
import io.fabric8.kubernetes.api.model.rbac.RoleBindingList;
import io.fabric8.kubernetes.api.model.rbac.RoleList;
import io.fabric8.kubernetes.api.model.version.Info;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "APIGroup",
    "APIGroupList",
    "AggregationRule",
    "BaseKubernetesList",
    "ClusterRole",
    "ClusterRoleBinding",
    "ClusterRoleBindingList",
    "ClusterRoleList",
    "CreateOptions",
    "DeleteOptions",
    "GetOptions",
    "Info",
    "ListOptions",
    "ObjectMeta",
    "Patch",
    "PatchOptions",
    "Quantity",
    "Role",
    "RoleBinding",
    "RoleBindingList",
    "RoleList",
    "RootPaths",
    "Status",
    "Time",
    "TypeMeta",
    "UpdateOptions"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(io.fabric8.kubernetes.api.model.ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class KubeSchema {

    /**
     * 
     * 
     */
    @JsonProperty("APIGroup")
    private APIGroup aPIGroup;
    /**
     * 
     * 
     */
    @JsonProperty("APIGroupList")
    private APIGroupList aPIGroupList;
    /**
     * 
     * 
     */
    @JsonProperty("AggregationRule")
    private AggregationRule aggregationRule;
    /**
     * 
     * 
     */
    @JsonProperty("BaseKubernetesList")
    private BaseKubernetesList baseKubernetesList;
    /**
     * 
     * 
     */
    @JsonProperty("ClusterRole")
    private ClusterRole clusterRole;
    /**
     * 
     * 
     */
    @JsonProperty("ClusterRoleBinding")
    private ClusterRoleBinding clusterRoleBinding;
    /**
     * 
     * 
     */
    @JsonProperty("ClusterRoleBindingList")
    private ClusterRoleBindingList clusterRoleBindingList;
    /**
     * 
     * 
     */
    @JsonProperty("ClusterRoleList")
    private ClusterRoleList clusterRoleList;
    /**
     * 
     * 
     */
    @JsonProperty("CreateOptions")
    private CreateOptions createOptions;
    /**
     * 
     * 
     */
    @JsonProperty("DeleteOptions")
    private DeleteOptions deleteOptions;
    /**
     * 
     * 
     */
    @JsonProperty("GetOptions")
    private GetOptions getOptions;
    /**
     * 
     * 
     */
    @JsonProperty("Info")
    private Info info;
    /**
     * 
     * 
     */
    @JsonProperty("ListOptions")
    private ListOptions listOptions;
    /**
     * 
     * 
     */
    @JsonProperty("ObjectMeta")
    private io.fabric8.kubernetes.api.model.ObjectMeta objectMeta;
    /**
     * 
     * 
     */
    @JsonProperty("Patch")
    private Patch patch;
    /**
     * 
     * 
     */
    @JsonProperty("PatchOptions")
    private PatchOptions patchOptions;
    /**
     * 
     * 
     */
    @JsonProperty("Quantity")
    private Quantity quantity;
    /**
     * 
     * 
     */
    @JsonProperty("Role")
    private Role role;
    /**
     * 
     * 
     */
    @JsonProperty("RoleBinding")
    private RoleBinding roleBinding;
    /**
     * 
     * 
     */
    @JsonProperty("RoleBindingList")
    private RoleBindingList roleBindingList;
    /**
     * 
     * 
     */
    @JsonProperty("RoleList")
    private RoleList roleList;
    /**
     * 
     * 
     */
    @JsonProperty("RootPaths")
    private RootPaths rootPaths;
    /**
     * 
     * 
     */
    @JsonProperty("Status")
    private Status status;
    /**
     * 
     * 
     */
    @JsonProperty("Time")
    private String time;
    /**
     * 
     * 
     */
    @JsonProperty("TypeMeta")
    private TypeMeta typeMeta;
    /**
     * 
     * 
     */
    @JsonProperty("UpdateOptions")
    private UpdateOptions updateOptions;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public KubeSchema() {
    }

    /**
     * 
     * @param listOptions
     * @param aPIGroupList
     * @param aggregationRule
     * @param role
     * @param roleBinding
     * @param baseKubernetesList
     * @param updateOptions
     * @param roleBindingList
     * @param patch
     * @param rootPaths
     * @param clusterRoleBindingList
     * @param info
     * @param patchOptions
     * @param deleteOptions
     * @param quantity
     * @param clusterRole
     * @param roleList
     * @param clusterRoleList
     * @param createOptions
     * @param aPIGroup
     * @param typeMeta
     * @param objectMeta
     * @param clusterRoleBinding
     * @param getOptions
     * @param time
     * @param status
     */
    public KubeSchema(APIGroup aPIGroup, APIGroupList aPIGroupList, AggregationRule aggregationRule, BaseKubernetesList baseKubernetesList, ClusterRole clusterRole, ClusterRoleBinding clusterRoleBinding, ClusterRoleBindingList clusterRoleBindingList, ClusterRoleList clusterRoleList, CreateOptions createOptions, DeleteOptions deleteOptions, GetOptions getOptions, Info info, ListOptions listOptions, io.fabric8.kubernetes.api.model.ObjectMeta objectMeta, Patch patch, PatchOptions patchOptions, Quantity quantity, Role role, RoleBinding roleBinding, RoleBindingList roleBindingList, RoleList roleList, RootPaths rootPaths, Status status, String time, TypeMeta typeMeta, UpdateOptions updateOptions) {
        this.aPIGroup = aPIGroup;
        this.aPIGroupList = aPIGroupList;
        this.aggregationRule = aggregationRule;
        this.baseKubernetesList = baseKubernetesList;
        this.clusterRole = clusterRole;
        this.clusterRoleBinding = clusterRoleBinding;
        this.clusterRoleBindingList = clusterRoleBindingList;
        this.clusterRoleList = clusterRoleList;
        this.createOptions = createOptions;
        this.deleteOptions = deleteOptions;
        this.getOptions = getOptions;
        this.info = info;
        this.listOptions = listOptions;
        this.objectMeta = objectMeta;
        this.patch = patch;
        this.patchOptions = patchOptions;
        this.quantity = quantity;
        this.role = role;
        this.roleBinding = roleBinding;
        this.roleBindingList = roleBindingList;
        this.roleList = roleList;
        this.rootPaths = rootPaths;
        this.status = status;
        this.time = time;
        this.typeMeta = typeMeta;
        this.updateOptions = updateOptions;
    }

    /**
     * 
     * 
     * @return
     *     The aPIGroup
     */
    @JsonProperty("APIGroup")
    public APIGroup getAPIGroup() {
        return aPIGroup;
    }

    /**
     * 
     * 
     * @param aPIGroup
     *     The APIGroup
     */
    @JsonProperty("APIGroup")
    public void setAPIGroup(APIGroup aPIGroup) {
        this.aPIGroup = aPIGroup;
    }

    /**
     * 
     * 
     * @return
     *     The aPIGroupList
     */
    @JsonProperty("APIGroupList")
    public APIGroupList getAPIGroupList() {
        return aPIGroupList;
    }

    /**
     * 
     * 
     * @param aPIGroupList
     *     The APIGroupList
     */
    @JsonProperty("APIGroupList")
    public void setAPIGroupList(APIGroupList aPIGroupList) {
        this.aPIGroupList = aPIGroupList;
    }

    /**
     * 
     * 
     * @return
     *     The aggregationRule
     */
    @JsonProperty("AggregationRule")
    public AggregationRule getAggregationRule() {
        return aggregationRule;
    }

    /**
     * 
     * 
     * @param aggregationRule
     *     The AggregationRule
     */
    @JsonProperty("AggregationRule")
    public void setAggregationRule(AggregationRule aggregationRule) {
        this.aggregationRule = aggregationRule;
    }

    /**
     * 
     * 
     * @return
     *     The baseKubernetesList
     */
    @JsonProperty("BaseKubernetesList")
    public BaseKubernetesList getBaseKubernetesList() {
        return baseKubernetesList;
    }

    /**
     * 
     * 
     * @param baseKubernetesList
     *     The BaseKubernetesList
     */
    @JsonProperty("BaseKubernetesList")
    public void setBaseKubernetesList(BaseKubernetesList baseKubernetesList) {
        this.baseKubernetesList = baseKubernetesList;
    }

    /**
     * 
     * 
     * @return
     *     The clusterRole
     */
    @JsonProperty("ClusterRole")
    public ClusterRole getClusterRole() {
        return clusterRole;
    }

    /**
     * 
     * 
     * @param clusterRole
     *     The ClusterRole
     */
    @JsonProperty("ClusterRole")
    public void setClusterRole(ClusterRole clusterRole) {
        this.clusterRole = clusterRole;
    }

    /**
     * 
     * 
     * @return
     *     The clusterRoleBinding
     */
    @JsonProperty("ClusterRoleBinding")
    public ClusterRoleBinding getClusterRoleBinding() {
        return clusterRoleBinding;
    }

    /**
     * 
     * 
     * @param clusterRoleBinding
     *     The ClusterRoleBinding
     */
    @JsonProperty("ClusterRoleBinding")
    public void setClusterRoleBinding(ClusterRoleBinding clusterRoleBinding) {
        this.clusterRoleBinding = clusterRoleBinding;
    }

    /**
     * 
     * 
     * @return
     *     The clusterRoleBindingList
     */
    @JsonProperty("ClusterRoleBindingList")
    public ClusterRoleBindingList getClusterRoleBindingList() {
        return clusterRoleBindingList;
    }

    /**
     * 
     * 
     * @param clusterRoleBindingList
     *     The ClusterRoleBindingList
     */
    @JsonProperty("ClusterRoleBindingList")
    public void setClusterRoleBindingList(ClusterRoleBindingList clusterRoleBindingList) {
        this.clusterRoleBindingList = clusterRoleBindingList;
    }

    /**
     * 
     * 
     * @return
     *     The clusterRoleList
     */
    @JsonProperty("ClusterRoleList")
    public ClusterRoleList getClusterRoleList() {
        return clusterRoleList;
    }

    /**
     * 
     * 
     * @param clusterRoleList
     *     The ClusterRoleList
     */
    @JsonProperty("ClusterRoleList")
    public void setClusterRoleList(ClusterRoleList clusterRoleList) {
        this.clusterRoleList = clusterRoleList;
    }

    /**
     * 
     * 
     * @return
     *     The createOptions
     */
    @JsonProperty("CreateOptions")
    public CreateOptions getCreateOptions() {
        return createOptions;
    }

    /**
     * 
     * 
     * @param createOptions
     *     The CreateOptions
     */
    @JsonProperty("CreateOptions")
    public void setCreateOptions(CreateOptions createOptions) {
        this.createOptions = createOptions;
    }

    /**
     * 
     * 
     * @return
     *     The deleteOptions
     */
    @JsonProperty("DeleteOptions")
    public DeleteOptions getDeleteOptions() {
        return deleteOptions;
    }

    /**
     * 
     * 
     * @param deleteOptions
     *     The DeleteOptions
     */
    @JsonProperty("DeleteOptions")
    public void setDeleteOptions(DeleteOptions deleteOptions) {
        this.deleteOptions = deleteOptions;
    }

    /**
     * 
     * 
     * @return
     *     The getOptions
     */
    @JsonProperty("GetOptions")
    public GetOptions getGetOptions() {
        return getOptions;
    }

    /**
     * 
     * 
     * @param getOptions
     *     The GetOptions
     */
    @JsonProperty("GetOptions")
    public void setGetOptions(GetOptions getOptions) {
        this.getOptions = getOptions;
    }

    /**
     * 
     * 
     * @return
     *     The info
     */
    @JsonProperty("Info")
    public Info getInfo() {
        return info;
    }

    /**
     * 
     * 
     * @param info
     *     The Info
     */
    @JsonProperty("Info")
    public void setInfo(Info info) {
        this.info = info;
    }

    /**
     * 
     * 
     * @return
     *     The listOptions
     */
    @JsonProperty("ListOptions")
    public ListOptions getListOptions() {
        return listOptions;
    }

    /**
     * 
     * 
     * @param listOptions
     *     The ListOptions
     */
    @JsonProperty("ListOptions")
    public void setListOptions(ListOptions listOptions) {
        this.listOptions = listOptions;
    }

    /**
     * 
     * 
     * @return
     *     The objectMeta
     */
    @JsonProperty("ObjectMeta")
    public io.fabric8.kubernetes.api.model.ObjectMeta getObjectMeta() {
        return objectMeta;
    }

    /**
     * 
     * 
     * @param objectMeta
     *     The ObjectMeta
     */
    @JsonProperty("ObjectMeta")
    public void setObjectMeta(io.fabric8.kubernetes.api.model.ObjectMeta objectMeta) {
        this.objectMeta = objectMeta;
    }

    /**
     * 
     * 
     * @return
     *     The patch
     */
    @JsonProperty("Patch")
    public Patch getPatch() {
        return patch;
    }

    /**
     * 
     * 
     * @param patch
     *     The Patch
     */
    @JsonProperty("Patch")
    public void setPatch(Patch patch) {
        this.patch = patch;
    }

    /**
     * 
     * 
     * @return
     *     The patchOptions
     */
    @JsonProperty("PatchOptions")
    public PatchOptions getPatchOptions() {
        return patchOptions;
    }

    /**
     * 
     * 
     * @param patchOptions
     *     The PatchOptions
     */
    @JsonProperty("PatchOptions")
    public void setPatchOptions(PatchOptions patchOptions) {
        this.patchOptions = patchOptions;
    }

    /**
     * 
     * 
     * @return
     *     The quantity
     */
    @JsonProperty("Quantity")
    public Quantity getQuantity() {
        return quantity;
    }

    /**
     * 
     * 
     * @param quantity
     *     The Quantity
     */
    @JsonProperty("Quantity")
    public void setQuantity(Quantity quantity) {
        this.quantity = quantity;
    }

    /**
     * 
     * 
     * @return
     *     The role
     */
    @JsonProperty("Role")
    public Role getRole() {
        return role;
    }

    /**
     * 
     * 
     * @param role
     *     The Role
     */
    @JsonProperty("Role")
    public void setRole(Role role) {
        this.role = role;
    }

    /**
     * 
     * 
     * @return
     *     The roleBinding
     */
    @JsonProperty("RoleBinding")
    public RoleBinding getRoleBinding() {
        return roleBinding;
    }

    /**
     * 
     * 
     * @param roleBinding
     *     The RoleBinding
     */
    @JsonProperty("RoleBinding")
    public void setRoleBinding(RoleBinding roleBinding) {
        this.roleBinding = roleBinding;
    }

    /**
     * 
     * 
     * @return
     *     The roleBindingList
     */
    @JsonProperty("RoleBindingList")
    public RoleBindingList getRoleBindingList() {
        return roleBindingList;
    }

    /**
     * 
     * 
     * @param roleBindingList
     *     The RoleBindingList
     */
    @JsonProperty("RoleBindingList")
    public void setRoleBindingList(RoleBindingList roleBindingList) {
        this.roleBindingList = roleBindingList;
    }

    /**
     * 
     * 
     * @return
     *     The roleList
     */
    @JsonProperty("RoleList")
    public RoleList getRoleList() {
        return roleList;
    }

    /**
     * 
     * 
     * @param roleList
     *     The RoleList
     */
    @JsonProperty("RoleList")
    public void setRoleList(RoleList roleList) {
        this.roleList = roleList;
    }

    /**
     * 
     * 
     * @return
     *     The rootPaths
     */
    @JsonProperty("RootPaths")
    public RootPaths getRootPaths() {
        return rootPaths;
    }

    /**
     * 
     * 
     * @param rootPaths
     *     The RootPaths
     */
    @JsonProperty("RootPaths")
    public void setRootPaths(RootPaths rootPaths) {
        this.rootPaths = rootPaths;
    }

    /**
     * 
     * 
     * @return
     *     The status
     */
    @JsonProperty("Status")
    public Status getStatus() {
        return status;
    }

    /**
     * 
     * 
     * @param status
     *     The Status
     */
    @JsonProperty("Status")
    public void setStatus(Status status) {
        this.status = status;
    }

    /**
     * 
     * 
     * @return
     *     The time
     */
    @JsonProperty("Time")
    public String getTime() {
        return time;
    }

    /**
     * 
     * 
     * @param time
     *     The Time
     */
    @JsonProperty("Time")
    public void setTime(String time) {
        this.time = time;
    }

    /**
     * 
     * 
     * @return
     *     The typeMeta
     */
    @JsonProperty("TypeMeta")
    public TypeMeta getTypeMeta() {
        return typeMeta;
    }

    /**
     * 
     * 
     * @param typeMeta
     *     The TypeMeta
     */
    @JsonProperty("TypeMeta")
    public void setTypeMeta(TypeMeta typeMeta) {
        this.typeMeta = typeMeta;
    }

    /**
     * 
     * 
     * @return
     *     The updateOptions
     */
    @JsonProperty("UpdateOptions")
    public UpdateOptions getUpdateOptions() {
        return updateOptions;
    }

    /**
     * 
     * 
     * @param updateOptions
     *     The UpdateOptions
     */
    @JsonProperty("UpdateOptions")
    public void setUpdateOptions(UpdateOptions updateOptions) {
        this.updateOptions = updateOptions;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
