package io.fabric8.kubernetes.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodSecurityPolicyListBuilder extends PodSecurityPolicyListFluentImpl<PodSecurityPolicyListBuilder> implements VisitableBuilder<PodSecurityPolicyList,io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicyListBuilder>{
  public PodSecurityPolicyListBuilder() {
    this(false);
  }
  public PodSecurityPolicyListBuilder(Boolean validationEnabled) {
    this(new PodSecurityPolicyList(), validationEnabled);
  }
  public PodSecurityPolicyListBuilder(io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicyListFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSecurityPolicyListBuilder(io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicyListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PodSecurityPolicyList(), validationEnabled);
  }
  public PodSecurityPolicyListBuilder(io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicyListFluent<?> fluent,io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicyList instance) {
    this(fluent, instance, false);
  }
  public PodSecurityPolicyListBuilder(io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicyListFluent<?> fluent,io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicyList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodSecurityPolicyListBuilder(io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicyList instance) {
    this(instance,false);
  }
  public PodSecurityPolicyListBuilder(io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicyList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicyListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicyList build() {
    PodSecurityPolicyList buildable = new PodSecurityPolicyList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}