package io.fabric8.kubernetes.api.model.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodDisruptionBudgetBuilder extends PodDisruptionBudgetFluentImpl<PodDisruptionBudgetBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.policy.v1.PodDisruptionBudget,PodDisruptionBudgetBuilder>{
  public PodDisruptionBudgetBuilder() {
    this(false);
  }
  public PodDisruptionBudgetBuilder(Boolean validationEnabled) {
    this(new PodDisruptionBudget(), validationEnabled);
  }
  public PodDisruptionBudgetBuilder(PodDisruptionBudgetFluent<?> fluent) {
    this(fluent, false);
  }
  public PodDisruptionBudgetBuilder(io.fabric8.kubernetes.api.model.policy.v1.PodDisruptionBudgetFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PodDisruptionBudget(), validationEnabled);
  }
  public PodDisruptionBudgetBuilder(io.fabric8.kubernetes.api.model.policy.v1.PodDisruptionBudgetFluent<?> fluent,io.fabric8.kubernetes.api.model.policy.v1.PodDisruptionBudget instance) {
    this(fluent, instance, false);
  }
  public PodDisruptionBudgetBuilder(io.fabric8.kubernetes.api.model.policy.v1.PodDisruptionBudgetFluent<?> fluent,io.fabric8.kubernetes.api.model.policy.v1.PodDisruptionBudget instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodDisruptionBudgetBuilder(io.fabric8.kubernetes.api.model.policy.v1.PodDisruptionBudget instance) {
    this(instance,false);
  }
  public PodDisruptionBudgetBuilder(io.fabric8.kubernetes.api.model.policy.v1.PodDisruptionBudget instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.policy.v1.PodDisruptionBudgetFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.policy.v1.PodDisruptionBudget build() {
    PodDisruptionBudget buildable = new PodDisruptionBudget(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}